/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.classic;

import diskCacheV111.util.CacheException;
import diskCacheV111.util.ChecksumFactory;
import diskCacheV111.util.PnfsHandler;
import diskCacheV111.util.PnfsId;
import dmg.util.Args;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.NoSuchAlgorithmException;
import java.util.EnumSet;
import java.util.concurrent.TimeUnit;
import org.dcache.cells.AbstractCellComponent;
import org.dcache.cells.CellCommandListener;
import org.dcache.namespace.FileAttribute;
import org.dcache.pool.classic.ChecksumScanner;
import org.dcache.util.Checksum;
import org.dcache.util.ChecksumType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChecksumModuleV1
extends AbstractCellComponent
implements CellCommandListener {
    private static final Logger _log = LoggerFactory.getLogger(ChecksumModuleV1.class);
    public static final long BYTES_IN_MEBIBYTE = 0x100000L;
    private boolean _onRead = false;
    private boolean _onWrite = false;
    private boolean _onTransfer = false;
    private boolean _onFlush = false;
    private boolean _onRestore = false;
    private boolean _enforceCRC = false;
    private boolean _updatepnfs = false;
    private volatile boolean _scrub = false;
    private volatile double _throughputLimit = Double.POSITIVE_INFINITY;
    private volatile long _scrubPeriod = TimeUnit.HOURS.toMillis(24L);
    private ChecksumFactory _defaultChecksumFactory = null;
    private ChecksumScanner _scanner = null;
    private final PnfsHandler _pnfs;
    public static final String hh_csm_info = "";
    public static final String hh_csm_set_policy = "[-<option>=on|off] ... # see 'help csm set policy";
    public static final String fh_csm_set_policy = "  Syntax : csm set policy [-<option>=on[|off]] ...\n\n    OPTIONS :\n       -scrub:  periodically verify pool data against checksums (suboptions :)\n\n            -limit=<MiB/s>|off : checksum computation throughput limit\n            -period=<hours>    : run scrubber every <hours> hours\n\n       -onread          : run check before each open for reading\n       -onwrite         : run check after receiving the file from client (on fs)\n       -onflush         : run check before flush to HSM\n       -onrestore       : run check after restore from HSM\n       -ontransfer      : run check while receiving data from client (on the fly)\n       -enforcecrc      : make sure there is at least one crc stored in pnfs\n       -getcrcfromhsm   : read the <pool>/data/<pnfsid>.crcval file and send to pnfs\n\n";
    public static final String hh_csm_set_checksumtype = "adler32|md5";

    public ChecksumModuleV1(PnfsHandler pnfs) {
        this._pnfs = pnfs;
        try {
            this._defaultChecksumFactory = ChecksumFactory.getFactory(ChecksumType.ADLER32);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("adler32 is not supported", e);
        }
    }

    private <T> T getFirstNonNull(T ... objects) {
        for (T t : objects) {
            if (t == null) continue;
            return t;
        }
        return null;
    }

    public void setChecksumScanner(ChecksumScanner scanner) {
        this._scanner = scanner;
    }

    public void setMoverChecksums(PnfsId id, File file, ChecksumFactory factory, Checksum clientChecksum, Checksum transferChecksum) throws CacheException, InterruptedException, IOException {
        Checksum fileChecksum;
        Checksum pnfsChecksum = clientChecksum == null ? factory.find(this._pnfs.getFileAttributes(id, EnumSet.of(FileAttribute.CHECKSUM)).getChecksums()) : null;
        Checksum checksum = this.getFirstNonNull(clientChecksum, pnfsChecksum, transferChecksum, fileChecksum = this._onWrite || this._onTransfer && transferChecksum == null ? factory.computeChecksum(file) : null);
        if (checksum == null) {
            if (!this._enforceCRC) {
                return;
            }
            checksum = factory.computeChecksum(file);
        }
        if (transferChecksum != null && !transferChecksum.equals((Object)checksum) || fileChecksum != null && !fileChecksum.equals((Object)checksum)) {
            throw new CacheException(String.format("Checksum error: client=%s,pnfs=%s,transfer=%s,file=%s", clientChecksum, pnfsChecksum, transferChecksum, fileChecksum));
        }
        if (pnfsChecksum == null && checksum != null) {
            _log.info("Storing checksum {} for {}", (Object)checksum, (Object)id);
            this._pnfs.setChecksum(id, checksum);
        }
    }

    public ChecksumFactory getDefaultChecksumFactory() {
        return this._defaultChecksumFactory;
    }

    @Override
    public void printSetup(PrintWriter pw) {
        pw.println("csm set checksumtype " + this._defaultChecksumFactory.getType());
        if (this._scrub) {
            pw.print("csm set policy -scrub=on");
            pw.print(" -limit=" + (Double.isInfinite(this._throughputLimit) ? "off" : Double.valueOf(this._throughputLimit / 1048576.0)));
            pw.println(" -period=" + TimeUnit.MILLISECONDS.toHours(this._scrubPeriod));
        } else {
            pw.println("csm set policy -scrub=off");
        }
        pw.print("csm set policy");
        pw.print(" -onread=");
        pw.print(this._onRead ? "on" : "off");
        pw.print(" -onwrite=");
        pw.print(this._onWrite ? "on" : "off");
        pw.print(" -onflush=");
        pw.print(this._onFlush ? "on" : "off");
        pw.print(" -onrestore=");
        pw.print(this._onRestore ? "on" : "off");
        pw.print(" -ontransfer=");
        pw.print(this._onTransfer ? "on" : "off");
        pw.print(" -enforcecrc=");
        pw.print(this._enforceCRC ? "on" : "off");
        pw.print(" -getcrcfromhsm=");
        pw.print(this._updatepnfs ? "on" : "off");
        pw.println(hh_csm_info);
    }

    public long getScrubPeriod() {
        return this._scrubPeriod;
    }

    public double getThroughputLimit() {
        return this._throughputLimit;
    }

    public boolean isScrubbingEnabled() {
        return this._scrub;
    }

    public boolean checkOnRead() {
        return this._onRead;
    }

    public boolean checkOnFlush() {
        return this._onFlush;
    }

    public boolean checkOnRestore() {
        return this._onRestore;
    }

    public boolean checkOnWrite() {
        return this._onWrite;
    }

    public boolean checkOnTransfer() {
        return this._onTransfer;
    }

    public boolean enforceCRC() {
        return this._enforceCRC;
    }

    @Override
    public void getInfo(PrintWriter pw) {
        pw.println("                Version : $Id: ChecksumModuleV1.java 16563 2011-11-05 10:43:03Z behrmann $");
        pw.println("          Checksum type : " + this._defaultChecksumFactory.getType());
        pw.print(" Checkum calculation on : ");
        if (this._onRead) {
            pw.print("read ");
        }
        if (this._onWrite) {
            pw.print("write ");
        }
        if (this._onFlush) {
            pw.print("flush ");
        }
        if (this._onRestore) {
            pw.print("restore ");
        }
        if (this._onTransfer) {
            pw.print("transfer ");
        }
        if (this._enforceCRC) {
            pw.print("enforceCRC ");
        }
        if (this._updatepnfs) {
            pw.print("getcrcfromhsm ");
        }
        if (this._scrub) {
            pw.print("scrub(");
            pw.print("limit=" + (Double.isInfinite(this._throughputLimit) ? "off" : Double.valueOf(this._throughputLimit / 1048576.0)));
            pw.print(",");
            pw.print("period=" + TimeUnit.MILLISECONDS.toHours(this._scrubPeriod));
            pw.print(")");
        }
        pw.println(hh_csm_info);
    }

    public String ac_csm_info_$_0(Args args) {
        return this.getPolicies();
    }

    private String getPolicies() {
        StringBuilder sb = new StringBuilder();
        sb.append(" Policies :\n").append("        on read : ").append(this._onRead).append("\n").append("       on write : ").append(this._onWrite).append("\n").append("       on flush : ").append(this._onFlush).append("\n").append("     on restore : ").append(this._onRestore).append("\n").append("    on transfer : ").append(this._onTransfer).append("\n").append("    enforce crc : ").append(this._enforceCRC).append("\n").append("  getcrcfromhsm : ").append(this._updatepnfs).append("\n").append("          scrub : ").append(this._scrub).append("\n");
        if (this._scrub) {
            if (Double.isInfinite(this._throughputLimit)) {
                sb.append("             limit  = off\n");
            } else {
                sb.append("             limit  = ").append(this._throughputLimit / 1048576.0).append(" MiB/s\n");
            }
            sb.append("             period = ").append(TimeUnit.MILLISECONDS.toHours(this._scrubPeriod)).append(" hours\n");
        }
        return sb.toString();
    }

    public String ac_csm_set_policy_$_0(Args args) {
        String periodOption;
        this._scrub = this.checkBoolean(args, "scrub", this._scrub);
        this._onRead = this.checkBoolean(args, "onread", this._onRead);
        this._onWrite = this.checkBoolean(args, "onwrite", this._onWrite);
        this._onFlush = this.checkBoolean(args, "onflush", this._onFlush);
        this._onRestore = this.checkBoolean(args, "onrestore", this._onRestore);
        this._onTransfer = this.checkBoolean(args, "ontransfer", this._onTransfer);
        this._enforceCRC = this.checkBoolean(args, "enforcecrc", this._enforceCRC);
        this._updatepnfs = this.checkBoolean(args, "getcrcfromhsm", this._updatepnfs);
        String limitOption = args.getOpt("limit");
        if (limitOption != null) {
            if (limitOption.equals("off")) {
                this._throughputLimit = Double.POSITIVE_INFINITY;
            } else {
                double limit = args.getDoubleOption("limit", this._throughputLimit / 1048576.0) * 1048576.0;
                if (limit <= 0.0) {
                    throw new IllegalArgumentException("Throughput limit must be > 0");
                }
                this._throughputLimit = limit;
            }
        }
        if ((periodOption = args.getOpt("period")) != null) {
            long period = TimeUnit.HOURS.toMillis(Integer.parseInt(periodOption));
            if (period <= 0L) {
                throw new IllegalArgumentException("Scrub interval must be > 0");
            }
            this._scrubPeriod = period;
        }
        if (this._scrub) {
            this._scanner.startScrubber();
        } else {
            this._scanner.stopScrubber();
        }
        return !args.hasOption("v") ? hh_csm_info : this.getPolicies();
    }

    public boolean getCrcFromHsm() {
        return this._updatepnfs;
    }

    public String ac_csm_set_checksumtype_$_1(Args args) throws Exception {
        String newChecksumType = args.argv(0);
        this._defaultChecksumFactory = ChecksumFactory.getFactory(ChecksumType.getChecksumType((String)newChecksumType));
        return "New checksumtype : " + this._defaultChecksumFactory.getType();
    }

    private boolean checkBoolean(Args args, String key, boolean currentValue) {
        String value = args.getOpt(key);
        if (value == null) {
            return currentValue;
        }
        if (value.equals("on") || value.equals(hh_csm_info)) {
            return true;
        }
        if (value.equals("off")) {
            return false;
        }
        throw new IllegalArgumentException("-" + key + "[=on|off]");
    }
}

