/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.classic;

import diskCacheV111.util.AccessLatency;
import diskCacheV111.util.RetentionPolicy;
import diskCacheV111.vehicles.StorageInfo;
import java.util.Collections;
import java.util.List;
import org.dcache.pool.classic.ReplicaStatePolicy;
import org.dcache.pool.repository.EntryState;
import org.dcache.pool.repository.StickyRecord;

public class ALRPReplicaStatePolicy
implements ReplicaStatePolicy {
    @Override
    public List<StickyRecord> getStickyRecords(StorageInfo info) {
        AccessLatency al = info.getAccessLatency();
        if (al != null && al.equals((Object)AccessLatency.ONLINE)) {
            return Collections.singletonList(new StickyRecord("system", -1L));
        }
        return Collections.emptyList();
    }

    @Override
    public EntryState getTargetState(StorageInfo info) {
        RetentionPolicy rp = info.getRetentionPolicy();
        if (info.getKey("overwrite") != null) {
            return EntryState.CACHED;
        }
        if (rp != null && !info.isStored() && rp.equals((Object)RetentionPolicy.CUSTODIAL)) {
            return EntryState.PRECIOUS;
        }
        return EntryState.CACHED;
    }
}

