/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pinmanager;

import com.google.common.base.Predicate;
import diskCacheV111.vehicles.PoolSetStickyMessage;
import dmg.cells.nucleus.CellPath;
import java.util.concurrent.Semaphore;
import javax.jdo.JDOException;
import org.dcache.cells.AbstractMessageCallback;
import org.dcache.cells.CellStub;
import org.dcache.pinmanager.PinDao;
import org.dcache.pinmanager.model.Pin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.transaction.annotation.Transactional;

public class UnpinProcessor
implements Runnable {
    private static final Logger _logger = LoggerFactory.getLogger(UnpinProcessor.class);
    private static final int MAX_RUNNING = 1000;
    private final PinDao _dao;
    private final CellStub _poolStub;

    public UnpinProcessor(PinDao dao, CellStub poolStub) {
        this._dao = dao;
        this._poolStub = poolStub;
    }

    @Override
    public void run() {
        try {
            Semaphore idle = new Semaphore(1000);
            this.unpin(idle);
            idle.acquire(1000);
        }
        catch (InterruptedException e) {
            _logger.debug(e.toString());
        }
        catch (JDOException e) {
            _logger.error("Database failure while unpinning: {}", (Object)e.getMessage());
        }
        catch (DataAccessException e) {
            _logger.error("Database failure while unpinning: {}", (Object)e.getMessage());
        }
        catch (RuntimeException e) {
            _logger.error("Unexpected failure while unpinning", (Throwable)e);
        }
    }

    @Transactional
    protected void unpin(final Semaphore idle) {
        this._dao.all(Pin.State.UNPINNING, new Predicate<Pin>(){

            public boolean apply(Pin pin) {
                try {
                    if (pin.getPool() == null || UnpinProcessor.this._dao.hasSharedSticky(pin)) {
                        UnpinProcessor.this._dao.deletePin(pin);
                    } else {
                        UnpinProcessor.this.clearStickyFlag(idle, pin);
                    }
                    return true;
                }
                catch (InterruptedException e) {
                    return false;
                }
            }
        });
    }

    private void clearStickyFlag(final Semaphore idle, final Pin pin) throws InterruptedException {
        idle.acquire();
        PoolSetStickyMessage msg = new PoolSetStickyMessage(pin.getPool(), pin.getPnfsId(), false, pin.getSticky(), 0L);
        this._poolStub.send(new CellPath(pin.getPool()), msg, PoolSetStickyMessage.class, new AbstractMessageCallback<PoolSetStickyMessage>(){

            @Override
            public void success(PoolSetStickyMessage msg) {
                idle.release();
                UnpinProcessor.this._dao.deletePin(pin);
            }

            @Override
            public void failure(int rc, Object error) {
                idle.release();
                switch (rc) {
                    case 10007: {
                        UnpinProcessor.this._dao.deletePin(pin);
                        break;
                    }
                    default: {
                        _logger.warn("Failed to clear sticky flag: {} [{}]", error, (Object)rc);
                    }
                }
            }
        });
    }
}

