/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pinmanager;

import diskCacheV111.util.CacheException;
import diskCacheV111.util.PnfsHandler;
import diskCacheV111.util.PnfsId;
import diskCacheV111.vehicles.DCapProtocolInfo;
import dmg.util.Args;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.dcache.cells.AbstractCellComponent;
import org.dcache.cells.CellCommandListener;
import org.dcache.cells.CellStub;
import org.dcache.namespace.FileAttribute;
import org.dcache.pinmanager.MovePinRequestProcessor;
import org.dcache.pinmanager.PinDao;
import org.dcache.pinmanager.PinManager;
import org.dcache.pinmanager.PinManagerExtendPinMessage;
import org.dcache.pinmanager.PinManagerPinMessage;
import org.dcache.pinmanager.PinManagerUnpinMessage;
import org.dcache.pinmanager.PinRequestProcessor;
import org.dcache.pinmanager.UnpinRequestProcessor;
import org.dcache.pinmanager.model.Pin;
import org.dcache.vehicles.FileAttributes;
import org.springframework.beans.factory.annotation.Required;

public class PinManagerCLI
extends AbstractCellComponent
implements CellCommandListener {
    private static final AtomicInteger _counter = new AtomicInteger(0);
    private final Map<Integer, BulkJob> _jobs = new ConcurrentHashMap<Integer, BulkJob>();
    private PnfsHandler _pnfs;
    private PinManager _pinManager;
    private PinDao _dao;
    private PinRequestProcessor _pinProcessor;
    private UnpinRequestProcessor _unpinProcessor;
    private MovePinRequestProcessor _moveProcessor;
    public static final String hh_pin = "<pnfs-id> <seconds> # pin a file by pnfsid for <seconds> seconds";
    public static final String fh_pin = "Pins a file to disk for some time. A file may be pinned forever by\nspecifying a lifetime of -1. Pinning a file may involve staging it\nor copying it from one pool to another. For that reason pinning may\ntake awhile and the pin command may time out. The pin request will\nhowever stay active and progress may be tracked by listing the pins\non the file.";
    public static final String hh_unpin = "<pin-ref> <pnfs-id> # unpin a file; <pin-ref> is either pin id or '*'";
    public static final String fh_unpin = "Unpin a previously pinned file. Either a specific pin or all pins on\na specific file can be removed.";
    public static final String hh_extend = "<pin-id> <pnfs-id> <seconds> # unpin a file";
    public static final String fh_extend = "Extend the lifetime of an existing pin. A pin with a lifetime of -1\nwill never expire and has to be unpinned explicitly. The lifetime\nof a pin can only be extended, not shortened.";
    public static final String hh_ls = "[<pin-id>|<pnfs-id>] # lists all pins or a specified pin by pin id or pnfsid";
    public static final String fh_ls = "Lists all pins or a specified pin by pin id or pnfsid.";
    public static final String hh_bulk_pin = "<file> <seconds> # pin pnfsids from <file> for <seconds>";
    public static final String fh_bulk_pin = "Pin a list of PNFS IDs from a file for a specified number of\nseconds. Each line of the file must be a PNFS ID.\n";
    public static final String hh_bulk_unpin = "<file> # unpin pnfsids from <file>";
    public static final String fh_bulk_unpin = "Unpin a list of PNFS IDs from a file. Each line of the file\nmust be a PNFS ID.";
    public static final String hh_bulk_clear = "# Removes completed jobs";
    public static final String fh_bulk_clear = "Removes completed jobs. For reference, information\nabout background jobs is kept until explicitly cleared.\n";
    public static final String hh_bulk_cancel = "<id> # cancels a background job";
    public static final String fh_bulk_cancel = "Cancels a background job. Notice that a cancelling a bulk job will\ncause all pins already created by the job to be released.";
    public static final String hh_bulk_ls = "[<id>] # list background jobs";
    public static final String fh_bulk_ls = "Lists background jobs. If a job id is specified then additionalstatus information about the job is provided.";

    @Required
    public void setPnfsStub(CellStub stub) {
        this._pnfs = new PnfsHandler(stub);
    }

    @Required
    public void setPinManager(PinManager pinManager) {
        this._pinManager = pinManager;
    }

    @Required
    public void setPinProcessor(PinRequestProcessor processor) {
        this._pinProcessor = processor;
    }

    @Required
    public void setUnpinProcessor(UnpinRequestProcessor processor) {
        this._unpinProcessor = processor;
    }

    @Required
    public void setMoveProcessor(MovePinRequestProcessor processor) {
        this._moveProcessor = processor;
    }

    @Required
    public void setDao(PinDao dao) {
        this._dao = dao;
    }

    private Future<PinManagerPinMessage> pin(PnfsId pnfsId, String requestId, long lifetime) throws CacheException {
        FileAttributes attributes = new FileAttributes();
        attributes.setPnfsId(pnfsId);
        DCapProtocolInfo protocolInfo = new DCapProtocolInfo("DCap", 3, 0, "localhost", 0);
        PinManagerPinMessage message = new PinManagerPinMessage(attributes, protocolInfo, requestId, lifetime);
        return this._pinProcessor.messageArrived(message);
    }

    public String ac_pin_$_2(Args args) throws NumberFormatException, CacheException, ExecutionException, InterruptedException {
        PinManagerPinMessage message;
        PnfsId pnfsId = new PnfsId(args.argv(0));
        long lifetime = Long.parseLong(args.argv(1));
        if (lifetime != -1L) {
            lifetime *= 1000L;
        }
        if ((message = this.pin(pnfsId, null, lifetime).get()).getExpirationTime() == null) {
            return String.format("[%d] %s pinned", message.getPinId(), pnfsId);
        }
        return String.format("[%d] %s pinned until %tc", message.getPinId(), pnfsId, message.getExpirationTime());
    }

    public String ac_unpin_$_2(Args args) throws NumberFormatException, CacheException, ExecutionException, InterruptedException {
        PnfsId pnfsId = new PnfsId(args.argv(1));
        PinManagerUnpinMessage message = new PinManagerUnpinMessage(pnfsId);
        if (!args.argv(0).equals("*")) {
            message.setPinId(Long.parseLong(args.argv(0)));
        }
        this._unpinProcessor.messageArrived(message);
        return "The pin is now scheduled for removal";
    }

    public String ac_extend_$_3(Args args) throws NumberFormatException, CacheException, ExecutionException, InterruptedException {
        long pinId = Long.parseLong(args.argv(0));
        PnfsId pnfsId = new PnfsId(args.argv(1));
        long lifetime = Long.parseLong(args.argv(2));
        if (lifetime != -1L) {
            lifetime *= 1000L;
        }
        EnumSet<FileAttribute> attributes = PinManagerExtendPinMessage.getRequiredAttributes();
        FileAttributes fileAttributes = this._pnfs.getFileAttributes(pnfsId, attributes);
        PinManagerExtendPinMessage message = new PinManagerExtendPinMessage(fileAttributes, pinId, lifetime);
        if ((message = this._moveProcessor.messageArrived(message)).getExpirationTime() == null) {
            return String.format("[%d] %s pinned", message.getPinId(), pnfsId);
        }
        return String.format("[%d] %s pinned until %tc", message.getPinId(), pnfsId, message.getExpirationTime());
    }

    public String ac_ls_$_0_1(Args args) {
        Collection<Pin> pins;
        if (args.argc() > 0) {
            String id = args.argv(0);
            if (!PnfsId.isValid(id)) {
                Pin pin = this._dao.getPin(Long.parseLong(id));
                return pin == null ? "" : pin.toString();
            }
            pins = this._dao.getPins(new PnfsId(id));
        } else {
            pins = this._dao.getPins();
        }
        StringBuilder out = new StringBuilder();
        for (Pin pin : pins) {
            out.append(pin).append("\n");
        }
        out.append("total ").append(pins.size());
        return out.toString();
    }

    public Object ac_bulk_pin_$_2(Args args) throws IOException, InterruptedException, CacheException {
        File file = new File(args.argv(0));
        long lifetime = Long.parseLong(args.argv(1));
        if (lifetime != -1L) {
            lifetime *= 1000L;
        }
        BulkJob job = new BulkJob(this.parse(file), lifetime);
        this._jobs.put(job.getId(), job);
        new Thread((Runnable)job, "BulkPin-" + job.getId()).start();
        return job.getJobDescription();
    }

    public Object ac_bulk_unpin_$_1(Args args) throws IOException, InterruptedException, CacheException {
        File file = new File(args.argv(0));
        StringBuilder out = new StringBuilder();
        for (PnfsId pnfsId : this.parse(file)) {
            try {
                PinManagerUnpinMessage message = new PinManagerUnpinMessage(pnfsId);
                this._unpinProcessor.messageArrived(message);
            }
            catch (CacheException e) {
                out.append(pnfsId).append(": ").append(e.getMessage()).append('\n');
            }
        }
        return out.toString();
    }

    public String ac_bulk_clear(Args args) {
        int count = 0;
        Iterator<BulkJob> i = this._jobs.values().iterator();
        while (i.hasNext()) {
            if (!i.next().isDone()) continue;
            i.remove();
            ++count;
        }
        return String.format("%d jobs removed", count);
    }

    public String ac_bulk_cancel_$_1(Args args) throws NumberFormatException, CacheException {
        BulkJob job = this._jobs.get(Integer.parseInt(args.argv(0)));
        if (job == null) {
            return "No such job";
        }
        job.cancel();
        return job.getJobDescription();
    }

    public String ac_bulk_ls_$_0_1(Args args) throws NumberFormatException, InterruptedException {
        if (args.argc() == 0) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<Integer, BulkJob> entry : this._jobs.entrySet()) {
                int id = entry.getKey();
                BulkJob job = entry.getValue();
                sb.append(job.getJobDescription()).append('\n');
            }
            return sb.toString();
        }
        BulkJob job = this._jobs.get(Integer.parseInt(args.argv(0)));
        if (job == null) {
            return "No such job";
        }
        return job.toString();
    }

    private List<PnfsId> parse(File file) throws IOException {
        ArrayList<PnfsId> list = new ArrayList<PnfsId>();
        BufferedReader reader = new BufferedReader(new FileReader(file));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                list.add(new PnfsId(line));
            }
        }
        catch (IllegalArgumentException e) {
            throw new IOException("Invalid file format: " + e.getMessage());
        }
        finally {
            reader.close();
        }
        return list;
    }

    static /* synthetic */ AtomicInteger access$000() {
        return _counter;
    }

    private class BulkJob
    implements Runnable {
        protected final Map<PnfsId, Future<PinManagerPinMessage>> _tasks = new HashMap<PnfsId, Future<PinManagerPinMessage>>();
        private final StringBuilder _errors = new StringBuilder();
        protected final String _requestId = UUID.randomUUID().toString();
        protected final int _id = PinManagerCLI.access$000().incrementAndGet();
        protected final long _lifetime;
        protected boolean _cancelled;

        public BulkJob(List<PnfsId> files, long lifetime) {
            this._lifetime = lifetime;
            for (PnfsId pnfsId : files) {
                this._tasks.put(pnfsId, null);
            }
        }

        @Override
        public void run() {
            ArrayList<PnfsId> list = new ArrayList<PnfsId>(this._tasks.keySet());
            for (PnfsId pnfsId : list) {
                try {
                    this._tasks.put(pnfsId, PinManagerCLI.this.pin(pnfsId, this._requestId, this._lifetime));
                }
                catch (CacheException e) {
                    this._tasks.remove(pnfsId);
                    this._errors.append("    ").append(pnfsId).append(": ").append(e.getMessage()).append('\n');
                }
                catch (RuntimeException e) {
                    this._tasks.remove(pnfsId);
                    this._errors.append("    ").append(pnfsId).append(": ").append(e.toString()).append('\n');
                }
            }
        }

        public int getId() {
            return this._id;
        }

        public synchronized void cancel() throws CacheException {
            if (!this._cancelled) {
                for (PnfsId pnfsId : this._tasks.keySet()) {
                    PinManagerUnpinMessage message = new PinManagerUnpinMessage(pnfsId);
                    message.setRequestId(this._requestId);
                    PinManagerCLI.this._unpinProcessor.messageArrived(message);
                }
                this._cancelled = true;
            }
        }

        public synchronized boolean isCancelled() {
            return this._cancelled;
        }

        public boolean isDone() {
            for (Future<PinManagerPinMessage> task : this._tasks.values()) {
                if (task != null && task.isDone()) continue;
                return false;
            }
            return true;
        }

        public String getJobDescription() {
            String state = this.isCancelled() ? "CANCELLED" : (this.isDone() ? "DONE" : "PROCESSING");
            return String.format("[%d] %s", this._id, state);
        }

        public String toString() {
            try {
                StringBuilder out = new StringBuilder();
                for (Map.Entry<PnfsId, Future<PinManagerPinMessage>> entry : this._tasks.entrySet()) {
                    out.append("  ").append(entry.getKey()).append(": ");
                    try {
                        Future<PinManagerPinMessage> future = entry.getValue();
                        if (future == null) {
                            out.append("INITIALIZING");
                        } else if (!future.isDone()) {
                            out.append("PROCESSING");
                        } else if (this.isCancelled()) {
                            out.append("CANCELLED");
                        } else {
                            future.get();
                            out.append("DONE");
                        }
                    }
                    catch (ExecutionException e) {
                        out.append(e.getMessage());
                    }
                    out.append('\n');
                }
                if (this._errors.length() > 0) {
                    out.append("Failed during initialization:\n");
                    out.append((CharSequence)this._errors);
                }
                return out.toString();
            }
            catch (InterruptedException e) {
                return e.toString();
            }
        }
    }
}

