/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pinmanager;

import diskCacheV111.vehicles.PoolRemoveFilesMessage;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.jdo.JDOException;
import org.dcache.cells.CellMessageReceiver;
import org.dcache.cells.CellStub;
import org.dcache.pinmanager.PinDao;
import org.dcache.pinmanager.UnpinProcessor;
import org.dcache.util.FireAndForgetTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.dao.DataAccessException;

public class PinManager
implements CellMessageReceiver {
    private static final Logger _log = LoggerFactory.getLogger(PinManager.class);
    private static final long INITIAL_EXPIRATION_DELAY = TimeUnit.SECONDS.toMillis(15L);
    private static final long INITIAL_UNPIN_DELAY = TimeUnit.SECONDS.toMillis(30L);
    private ScheduledExecutorService _executor;
    private PinDao _dao;
    private CellStub _poolStub;
    private long _expirationPeriod;

    @Required
    public void setExecutor(ScheduledExecutorService executor) {
        this._executor = executor;
    }

    @Required
    public void setDao(PinDao dao) {
        this._dao = dao;
    }

    @Required
    public void setPoolStub(CellStub stub) {
        this._poolStub = stub;
    }

    @Required
    public void setExpirationPeriod(long period) {
        this._expirationPeriod = period;
    }

    public long getExpirationPeriod() {
        return this._expirationPeriod;
    }

    public void init() {
        FireAndForgetTask expirationTask = new FireAndForgetTask(new ExpirationTask());
        this._executor.scheduleWithFixedDelay(expirationTask, INITIAL_EXPIRATION_DELAY, this._expirationPeriod, TimeUnit.MILLISECONDS);
        FireAndForgetTask unpinProcessor = new FireAndForgetTask(new UnpinProcessor(this._dao, this._poolStub));
        this._executor.scheduleWithFixedDelay(unpinProcessor, INITIAL_UNPIN_DELAY, this._expirationPeriod, TimeUnit.MILLISECONDS);
    }

    public void messageArrived(PoolRemoveFilesMessage message) {
        this._dao.deletePins(message.getFiles());
    }

    private class ExpirationTask
    implements Runnable {
        private ExpirationTask() {
        }

        @Override
        public void run() {
            try {
                PinManager.this._dao.expirePins();
            }
            catch (JDOException e) {
                _log.error("Database failure while expiring pins: {}", (Object)e.getMessage());
            }
            catch (DataAccessException e) {
                _log.error("Database failure while expiring pins: {}", (Object)e.getMessage());
            }
            catch (RuntimeException e) {
                _log.error("Unexpected failure while expiring pins", (Throwable)e);
            }
        }
    }
}

