/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pinmanager;

import diskCacheV111.util.CacheException;
import diskCacheV111.util.InvalidMessageCacheException;
import diskCacheV111.util.PermissionDeniedCacheException;
import diskCacheV111.util.PnfsId;
import diskCacheV111.util.TimeoutCacheException;
import diskCacheV111.vehicles.PoolSetStickyMessage;
import dmg.cells.nucleus.CellPath;
import java.util.Collection;
import java.util.Date;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.dcache.auth.Subjects;
import org.dcache.cells.CellMessageReceiver;
import org.dcache.cells.CellStub;
import org.dcache.pinmanager.AuthorizationPolicy;
import org.dcache.pinmanager.PinDao;
import org.dcache.pinmanager.PinManagerExtendPinMessage;
import org.dcache.pinmanager.model.Pin;
import org.dcache.pool.repository.StickyRecord;
import org.dcache.services.pinmanager1.PinManagerMovePinMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

public class MovePinRequestProcessor
implements CellMessageReceiver {
    private static final Logger _log = LoggerFactory.getLogger(MovePinRequestProcessor.class);
    private static final long POOL_LIFETIME_MARGIN = TimeUnit.MINUTES.toMillis(30L);
    private PinDao _dao;
    private CellStub _poolStub;
    private AuthorizationPolicy _pdp;
    private long _maxLifetime;

    @Required
    public void setDao(PinDao dao) {
        this._dao = dao;
    }

    @Required
    public void setPoolStub(CellStub stub) {
        this._poolStub = stub;
    }

    @Required
    public void setAuthorizationPolicy(AuthorizationPolicy pdp) {
        this._pdp = pdp;
    }

    @Required
    public void setMaxLifetime(long maxLifetime) {
        this._maxLifetime = maxLifetime;
    }

    @Required
    public long getMaxLifetime() {
        return this._maxLifetime;
    }

    protected Pin createTemporaryPin(PnfsId pnfsId, String pool) throws CacheException {
        long now = System.currentTimeMillis();
        Pin pin = new Pin(Subjects.ROOT, pnfsId);
        pin.setState(Pin.State.PINNING);
        pin.setPool(pool);
        pin.setSticky("PinManager-" + UUID.randomUUID().toString());
        pin.setExpirationTime(new Date(now + 2L * this._poolStub.getTimeout()));
        return this._dao.storePin(pin);
    }

    @Transactional(isolation=Isolation.REPEATABLE_READ)
    protected Pin swapPins(Pin pin, Pin tmpPin, Date expirationTime) throws CacheException {
        Pin targetPin = this._dao.getPin(tmpPin.getPinId(), tmpPin.getSticky(), Pin.State.PINNING);
        if (targetPin == null) {
            targetPin = new Pin(Subjects.ROOT, pin.getPnfsId());
            targetPin.setPool(tmpPin.getPool());
            targetPin.setSticky(tmpPin.getSticky());
            targetPin.setState(Pin.State.UNPINNING);
            this._dao.storePin(targetPin);
            throw new TimeoutCacheException("Move expired");
        }
        Pin sourcePin = this._dao.getPin(pin.getPinId(), pin.getSticky(), Pin.State.PINNED);
        if (sourcePin == null) {
            throw new CacheException("Pin no longer valid");
        }
        sourcePin.setPool(targetPin.getPool());
        sourcePin.setSticky(targetPin.getSticky());
        sourcePin.setExpirationTime(expirationTime);
        this._dao.storePin(sourcePin);
        targetPin.setPool(pin.getPool());
        targetPin.setSticky(pin.getSticky());
        targetPin.setState(Pin.State.UNPINNING);
        return this._dao.storePin(targetPin);
    }

    private void setSticky(String pool, PnfsId pnfsId, boolean sticky, String owner, long validTill) throws CacheException, InterruptedException {
        PoolSetStickyMessage msg = new PoolSetStickyMessage(pool, pnfsId, sticky, owner, validTill);
        this._poolStub.sendAndWait(new CellPath(pool), msg);
    }

    protected Pin move(Pin pin, String pool, Date expirationTime) throws CacheException, InterruptedException {
        Pin tmpPin = this.createTemporaryPin(pin.getPnfsId(), pool);
        this.setSticky(tmpPin.getPool(), tmpPin.getPnfsId(), true, tmpPin.getSticky(), expirationTime == null ? -1L : expirationTime.getTime() + POOL_LIFETIME_MARGIN);
        return this.swapPins(pin, tmpPin, expirationTime);
    }

    private boolean containsPin(Collection<Pin> pins, String sticky) {
        for (Pin pin : pins) {
            if (!sticky.equals(pin.getSticky())) continue;
            return true;
        }
        return false;
    }

    public PinManagerMovePinMessage messageArrived(PinManagerMovePinMessage message) throws CacheException, InterruptedException {
        PnfsId pnfsId = message.getPnfsId();
        String source = message.getSourcePool();
        String target = message.getTargetPool();
        Collection<Pin> pins = this._dao.getPins(pnfsId, source);
        for (StickyRecord record : message.getRecords()) {
            if (this.containsPin(pins, record.owner())) continue;
            this.setSticky(source, pnfsId, false, record.owner(), 0L);
        }
        for (Pin pin : pins) {
            Pin tmpPin = this.move(pin, target, pin.getExpirationTime());
            if (this._dao.hasSharedSticky(tmpPin)) continue;
            this.setSticky(tmpPin.getPool(), tmpPin.getPnfsId(), false, tmpPin.getSticky(), 0L);
            this._dao.deletePin(tmpPin);
        }
        _log.info("Moved pins for {} from {} to {}", new Object[]{pnfsId, source, target});
        return message;
    }

    public PinManagerExtendPinMessage messageArrived(PinManagerExtendPinMessage message) throws CacheException, InterruptedException {
        long lifetime;
        Pin pin = this._dao.getPin(message.getFileAttributes().getPnfsId(), message.getPinId());
        if (pin == null) {
            throw new InvalidMessageCacheException("Pin does not exist");
        }
        if (!this._pdp.canExtend(message.getSubject(), pin)) {
            throw new PermissionDeniedCacheException("Access denied");
        }
        if (pin.getState() == Pin.State.PINNING) {
            throw new InvalidMessageCacheException("File is not pinned yet");
        }
        if (pin.getState() == Pin.State.UNPINNING) {
            throw new InvalidMessageCacheException("Pin is no longer valid");
        }
        if (this._maxLifetime > -1L) {
            message.setLifetime(Math.min(this._maxLifetime, message.getLifetime()));
        }
        if (pin.hasRemainingLifetimeLessThan(lifetime = message.getLifetime())) {
            long now = System.currentTimeMillis();
            Date date = lifetime == -1L ? null : new Date(now + lifetime);
            this.move(pin, pin.getPool(), date);
            message.setExpirationTime(date);
        } else {
            message.setExpirationTime(pin.getExpirationTime());
        }
        _log.info("Extended pin for {} ({})", (Object)pin.getPnfsId(), (Object)pin.getPinId());
        return message;
    }
}

