/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.namespace;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import javax.security.auth.Subject;
import org.dcache.acl.ACL;
import org.dcache.acl.Owner;
import org.dcache.acl.Permission;
import org.dcache.acl.enums.AccessType;
import org.dcache.acl.enums.Action;
import org.dcache.acl.mapper.AclMapper;
import org.dcache.acl.matcher.AclNFSv4Matcher;
import org.dcache.auth.Origin;
import org.dcache.auth.Subjects;
import org.dcache.namespace.FileAttribute;
import org.dcache.namespace.PermissionHandler;
import org.dcache.vehicles.FileAttributes;

public class ACLPermissionHandler
implements PermissionHandler {
    private Set<FileAttribute> _requiredAttributes = Collections.unmodifiableSet(EnumSet.of(FileAttribute.ACL, FileAttribute.OWNER, FileAttribute.OWNER_GROUP));

    @Override
    public Set<FileAttribute> getRequiredAttributes() {
        return this._requiredAttributes;
    }

    private Permission getPermission(Subject subject, FileAttributes attr) {
        ACL acl = attr.getAcl();
        Owner owner = new Owner(attr.getOwner(), attr.getGroup());
        Origin origin = Subjects.getOrigin((Subject)subject);
        return AclMapper.getPermission((Subject)subject, (Origin)origin, (Owner)owner, (ACL)acl);
    }

    @Override
    public AccessType canReadFile(Subject subject, FileAttributes attr) {
        Permission permission = this.getPermission(subject, attr);
        return AccessType.valueOf((Boolean)AclNFSv4Matcher.isAllowed((Permission)permission, (Action)Action.READ));
    }

    @Override
    public AccessType canWriteFile(Subject subject, FileAttributes attr) {
        Permission permission = this.getPermission(subject, attr);
        return AccessType.valueOf((Boolean)AclNFSv4Matcher.isAllowed((Permission)permission, (Action)Action.WRITE));
    }

    @Override
    public AccessType canCreateSubDir(Subject subject, FileAttributes attr) {
        Permission permission = this.getPermission(subject, attr);
        return AccessType.valueOf((Boolean)AclNFSv4Matcher.isAllowed((Permission)permission, (Action)Action.CREATE, (Boolean)true));
    }

    @Override
    public AccessType canCreateFile(Subject subject, FileAttributes attr) {
        Permission permission = this.getPermission(subject, attr);
        return AccessType.valueOf((Boolean)AclNFSv4Matcher.isAllowed((Permission)permission, (Action)Action.CREATE, (Boolean)false));
    }

    @Override
    public AccessType canDeleteFile(Subject subject, FileAttributes parentAttr, FileAttributes childAttr) {
        Permission permissionParent = this.getPermission(subject, parentAttr);
        Permission permissionChild = this.getPermission(subject, childAttr);
        return AccessType.valueOf((Boolean)AclNFSv4Matcher.isAllowed((Permission)permissionParent, (Permission)permissionChild, (Action)Action.REMOVE, (Boolean)false));
    }

    @Override
    public AccessType canDeleteDir(Subject subject, FileAttributes parentAttr, FileAttributes childAttr) {
        Permission permissionParent = this.getPermission(subject, parentAttr);
        Permission permissionChild = this.getPermission(subject, childAttr);
        return AccessType.valueOf((Boolean)AclNFSv4Matcher.isAllowed((Permission)permissionParent, (Permission)permissionChild, (Action)Action.REMOVE, (Boolean)true));
    }

    @Override
    public AccessType canListDir(Subject subject, FileAttributes attr) {
        Permission permission = this.getPermission(subject, attr);
        return AccessType.valueOf((Boolean)AclNFSv4Matcher.isAllowed((Permission)permission, (Action)Action.READDIR));
    }

    @Override
    public AccessType canLookup(Subject subject, FileAttributes attr) {
        Permission permission = this.getPermission(subject, attr);
        return AccessType.valueOf((Boolean)AclNFSv4Matcher.isAllowed((Permission)permission, (Action)Action.LOOKUP));
    }

    @Override
    public AccessType canRename(Subject subject, FileAttributes parentAttr, FileAttributes newParentAttr, boolean isDirectory) {
        Permission permission1 = this.getPermission(subject, parentAttr);
        Permission permission2 = this.getPermission(subject, newParentAttr);
        return AccessType.valueOf((Boolean)AclNFSv4Matcher.isAllowed((Permission)permission1, (Permission)permission2, (Action)Action.RENAME, (Boolean)isDirectory));
    }

    @Override
    public AccessType canSetAttributes(Subject subject, FileAttributes parentAttr, FileAttributes attr, Set<FileAttribute> attributes) {
        Permission permission = this.getPermission(subject, attr);
        return this.canSetGetAttributes(permission, attributes, Action.SETATTR);
    }

    @Override
    public AccessType canGetAttributes(Subject subject, FileAttributes parentAttr, FileAttributes attr, Set<FileAttribute> attributes) {
        Permission permission = this.getPermission(subject, attr);
        return this.canSetGetAttributes(permission, attributes, Action.GETATTR);
    }

    private AccessType canSetGetAttributes(Permission permission, Set<FileAttribute> attributes, Action action) {
        boolean allAllowed = true;
        for (FileAttribute a : attributes) {
            org.dcache.acl.enums.FileAttribute nfs4 = a.toNfs4Attribute();
            AccessType allowed = nfs4 == null ? AccessType.ACCESS_ALLOWED : AccessType.valueOf((Boolean)AclNFSv4Matcher.isAllowed((Permission)permission, (Action)action, (org.dcache.acl.enums.FileAttribute)nfs4));
            switch (allowed) {
                case ACCESS_DENIED: {
                    return AccessType.ACCESS_DENIED;
                }
                case ACCESS_UNDEFINED: {
                    allAllowed = false;
                    break;
                }
            }
        }
        return allAllowed ? AccessType.ACCESS_ALLOWED : AccessType.ACCESS_UNDEFINED;
    }
}

