/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.http;

import com.google.common.base.CharMatcher;
import diskCacheV111.util.HttpByteRange;
import dmg.util.HttpException;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.Charset;
import java.util.List;
import org.dcache.util.StringMarkup;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.codec.frame.TooLongFrameException;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.timeout.IdleStateAwareChannelHandler;
import org.jboss.netty.util.CharsetUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestHandler
extends IdleStateAwareChannelHandler {
    private static final String RANGE_SEPARATOR = "-";
    private static final String RANGE_PRE_TOTAL = "/";
    private static final String RANGE_SP = " ";
    private static final String BOUNDARY = "__AAAAAAAAAAAAAAAA__";
    private static final String MULTIPART_TYPE = "multipart/byteranges; boundary=\"__AAAAAAAAAAAAAAAA__\"";
    private static final String CRLF = "\r\n";
    private static final CharMatcher TSPECIAL = CharMatcher.anyOf((CharSequence)"()<>@,;:\\\"/[]?=");
    private static final Logger _logger = LoggerFactory.getLogger(HttpRequestHandler.class);
    private boolean _isKeepAlive;

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent event) {
        if (event.getMessage() instanceof HttpRequest) {
            HttpRequest request = (HttpRequest)event.getMessage();
            this._isKeepAlive = HttpHeaders.isKeepAlive((HttpMessage)request);
            if (request.getMethod() == HttpMethod.GET) {
                this.doOnGet(ctx, event, request);
            } else if (request.getMethod() == HttpMethod.PUT) {
                this.doOnPut(ctx, event, request);
            } else if (request.getMethod() == HttpMethod.POST) {
                this.doOnPost(ctx, event, request);
            } else if (request.getMethod() == HttpMethod.DELETE) {
                this.doOnDelete(ctx, event, request);
            } else {
                this.unsupported(ctx, event);
            }
        }
    }

    protected void doOnGet(ChannelHandlerContext context, MessageEvent event, HttpRequest request) {
        _logger.info("Received a GET request, writing a default response.");
        this.unsupported(context, event);
    }

    protected void doOnPut(ChannelHandlerContext context, MessageEvent event, HttpRequest request) {
        _logger.info("Received a PUT request, writing a default response.");
        this.unsupported(context, event);
    }

    protected void doOnPost(ChannelHandlerContext context, MessageEvent event, HttpRequest request) {
        _logger.info("Received a POST request, writing default response.");
        this.unsupported(context, event);
    }

    protected void doOnDelete(ChannelHandlerContext context, MessageEvent event, HttpRequest request) {
        _logger.info("Received a DELETE request, writing default response.");
        this.unsupported(context, event);
    }

    protected ChannelFuture sendHTTPError(ChannelHandlerContext context, HttpResponseStatus statusCode, String message) {
        _logger.info("Sending error {} with message {} to client.", (Object)statusCode, (Object)message);
        if (message == null || message.isEmpty()) {
            message = "An unexpected server error has occurred.";
        }
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, statusCode);
        response.setHeader("Content-Type", (Object)"text/plain; charset=UTF-8");
        response.setContent(ChannelBuffers.copiedBuffer((CharSequence)(message + CRLF), (Charset)CharsetUtil.UTF_8));
        HttpHeaders.setContentLength((HttpMessage)response, (long)response.getContent().readableBytes());
        return context.getChannel().write((Object)response);
    }

    protected ChannelFuture sendFatalError(ChannelHandlerContext context, HttpResponseStatus statusCode, String message) {
        _logger.info("Sending error {} with message {} to client.", (Object)statusCode, (Object)message);
        if (message == null || message.isEmpty()) {
            message = "An unexpected server error has occurred.";
        }
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, statusCode);
        response.setHeader("Content-Type", (Object)"text/plain; charset=UTF-8");
        response.setHeader("Connection", (Object)"close");
        response.setContent(ChannelBuffers.copiedBuffer((CharSequence)(message + CRLF), (Charset)CharsetUtil.UTF_8));
        HttpHeaders.setContentLength((HttpMessage)response, (long)response.getContent().readableBytes());
        ChannelFuture future = context.getChannel().write((Object)response);
        future.addListener(ChannelFutureListener.CLOSE);
        return future;
    }

    protected ChannelFuture sendHTTPPartialHeader(ChannelHandlerContext context, MessageEvent event, long lower, long upper, long total) throws IOException {
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.PARTIAL_CONTENT);
        String contentRange = "bytes " + lower + RANGE_SEPARATOR + upper + RANGE_PRE_TOTAL + total;
        response.setHeader("Accept-Ranges", (Object)"bytes");
        response.setHeader("Content-Length", (Object)String.valueOf(upper - lower + 1L));
        response.setHeader("Content-Range", (Object)contentRange);
        return event.getChannel().write((Object)response);
    }

    protected ChannelFuture sendHTTPMultipartHeader(ChannelHandlerContext context, MessageEvent event) throws IOException {
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.PARTIAL_CONTENT);
        response.setHeader("Accept-Ranges", (Object)"bytes");
        response.setHeader("Content-Type", (Object)MULTIPART_TYPE);
        return event.getChannel().write((Object)response);
    }

    protected ChannelFuture sendHTTPMultipartFragment(ChannelHandlerContext context, MessageEvent event, long lower, long upper, long total) throws IOException {
        StringBuilder sb = new StringBuilder(64);
        sb.append(CRLF);
        sb.append("--").append(BOUNDARY).append(CRLF);
        sb.append("Content-Length").append(": ").append(upper - lower + 1L).append(CRLF);
        sb.append("Content-Range").append(": ").append("bytes").append(RANGE_SP).append(lower).append(RANGE_SEPARATOR).append(upper).append(RANGE_PRE_TOTAL).append(total).append(CRLF);
        sb.append(CRLF);
        ChannelBuffer buffer = ChannelBuffers.copiedBuffer((CharSequence)sb, (Charset)CharsetUtil.UTF_8);
        return event.getChannel().write((Object)buffer);
    }

    protected ChannelFuture sendHTTPMultipartEnd(ChannelHandlerContext context, MessageEvent event) throws IOException {
        StringBuilder sb = new StringBuilder(64);
        sb.append(CRLF);
        sb.append("--").append(BOUNDARY).append("--").append(CRLF);
        ChannelBuffer buffer = ChannelBuffers.copiedBuffer((CharSequence)sb, (Charset)CharsetUtil.UTF_8);
        return event.getChannel().write((Object)buffer);
    }

    protected ChannelFuture sendHTTPFullHeader(ChannelHandlerContext context, MessageEvent event, long contentLength, String filename) {
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        response.setHeader("Content-Length", (Object)contentLength);
        response.setHeader("Content-Disposition", (Object)this.contentDisposition(filename));
        return event.getChannel().write((Object)response);
    }

    private String contentDisposition(String filename) {
        StringBuilder sb = new StringBuilder();
        sb.append("attachment");
        this.appendDispositionParm(sb, "filename", filename);
        return sb.toString();
    }

    private void appendDispositionParm(StringBuilder sb, String name, String value) {
        sb.append(';');
        if (value.length() > 78 || !CharMatcher.ASCII.matchesAllOf((CharSequence)value)) {
            HttpRequestHandler.appendUsingRfc2231Encoding(sb, name, "UTF-8", null, value);
        } else if (TSPECIAL.matchesAnyOf((CharSequence)value)) {
            HttpRequestHandler.appendAsQuotedString(sb, name, value);
        } else {
            sb.append(name).append("=").append(value);
        }
    }

    private static void appendAsQuotedString(StringBuilder sb, String name, String value) {
        sb.append(name).append("=");
        StringMarkup.quotedString((StringBuilder)sb, (String)value);
    }

    private static void appendUsingRfc2231Encoding(StringBuilder sb, String name, String charSet, String language, String value) {
        sb.append(name).append("*=");
        if (charSet != null) {
            sb.append(charSet);
        }
        sb.append('\'');
        if (language != null) {
            sb.append(language);
        }
        sb.append('\'');
        StringMarkup.percentEncode((StringBuilder)sb, (String)value);
    }

    protected ChannelFuture unsupported(ChannelHandlerContext context, MessageEvent event) {
        return this.sendHTTPError(context, HttpResponseStatus.NOT_IMPLEMENTED, "The requested operation is not supported by dCache");
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent event) {
        Throwable t = event.getCause();
        if (t instanceof TooLongFrameException) {
            this.sendFatalError(ctx, HttpResponseStatus.BAD_REQUEST, "Max request length exceeded");
        } else if (event.getChannel().isConnected()) {
            event.getChannel().close();
        }
        if (t instanceof ClosedChannelException) {
            _logger.info("Connection unexpectedly closed");
        } else if (t instanceof RuntimeException || t instanceof Error) {
            Thread me = Thread.currentThread();
            me.getUncaughtExceptionHandler().uncaughtException(me, t);
        } else {
            _logger.warn(t.toString());
        }
    }

    protected boolean isKeepAlive() {
        return this._isKeepAlive;
    }

    protected List<HttpByteRange> parseHttpRange(HttpRequest request, long lowerRange, long upperRange) throws HttpException, IOException {
        block3: {
            String rangeHeader = request.getHeader("Range");
            if (rangeHeader != null) {
                try {
                    return HttpByteRange.parseRanges(rangeHeader, lowerRange, upperRange);
                }
                catch (HttpException e) {
                    if (request.getHeader("If-Range") != null) break block3;
                    throw e;
                }
            }
        }
        return null;
    }
}

