/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.http;

import diskCacheV111.util.CacheException;
import diskCacheV111.util.FsPath;
import diskCacheV111.util.PnfsId;
import diskCacheV111.util.TimeoutCacheException;
import diskCacheV111.vehicles.HttpDoorUrlInfoMessage;
import diskCacheV111.vehicles.HttpProtocolInfo;
import diskCacheV111.vehicles.ProtocolInfo;
import diskCacheV111.vehicles.StorageInfo;
import dmg.cells.nucleus.CellEndpoint;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.NoRouteToCellException;
import dmg.cells.nucleus.SerializationException;
import dmg.util.Args;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.dcache.http.HttpPoolNettyServer;
import org.dcache.http.HttpPoolRequestHandler;
import org.dcache.http.ReusableChunkedNioFile;
import org.dcache.pool.movers.IoMode;
import org.dcache.pool.movers.MoverProtocol;
import org.dcache.pool.repository.Allocator;
import org.dcache.pool.repository.RepositoryChannel;
import org.dcache.util.NetworkUtils;
import org.jboss.netty.handler.stream.ChunkedInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpProtocol_2
implements MoverProtocol {
    public static final String UUID_QUERY_PARAM = "dcache-http-uuid";
    private static final String QUERY_PARAM_ASSIGN = "=";
    private static final String PROTOCOL_HTTP = "http";
    private HttpProtocolInfo _protocolInfo;
    private RepositoryChannel _fileChannel;
    private final CountDownLatch _connectLatch = new CountDownLatch(1);
    private final long _connectTimeout;
    private final int _chunkSize;
    private final CellEndpoint _endpoint;
    private static HttpPoolNettyServer _server;
    private long _transferStarted;
    private volatile boolean _wasChanged = false;
    private final HttpResourceMonitor _httpMonitor = new HttpResourceMonitor();
    private static final Logger _logger;

    protected static synchronized void initSharedResources(Args args) {
        if (_server == null) {
            int threads = args.getIntOption("http-mover-disk-threads");
            int perChannelLimit = args.getIntOption("http-mover-max-memory-per-connection");
            int totalLimit = args.getIntOption("http-mover-max-memory");
            int maxChunkSize = args.getIntOption("http-mover-max-chunk-size");
            int timeoutInSeconds = args.getIntOption("http-mover-client-idle-timeout");
            int clientIdleTimeout = (int)TimeUnit.SECONDS.toMillis(timeoutInSeconds);
            String socketThreads = args.getOpt("http-mover-socket-threads");
            _server = socketThreads == null || socketThreads.isEmpty() ? new HttpPoolNettyServer(threads, perChannelLimit, totalLimit, maxChunkSize, clientIdleTimeout) : new HttpPoolNettyServer(threads, perChannelLimit, totalLimit, maxChunkSize, clientIdleTimeout, Integer.parseInt(socketThreads));
        }
    }

    public HttpProtocol_2(CellEndpoint endpoint) {
        this._endpoint = endpoint;
        Args args = this._endpoint.getArgs();
        long connect = args.getLongOption("http-mover-connect-timeout");
        this._connectTimeout = connect * 1000L;
        this._chunkSize = args.getIntOption("http-mover-chunk-size");
        HttpProtocol_2.initSharedResources(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runIO(RepositoryChannel fileChannel, ProtocolInfo protocol, StorageInfo storage, PnfsId pnfsId, Allocator allocator, IoMode access) throws Exception {
        this._protocolInfo = (HttpProtocolInfo)protocol;
        _logger.debug("Starting xrootd server");
        UUID uuid = UUID.randomUUID();
        try {
            this._httpMonitor.setInProgress(true);
            _server.register(uuid, this);
            InetSocketAddress address = _server.getServerAddress();
            this.sendAddressToDoor(address.getPort(), uuid, pnfsId);
            this._fileChannel = fileChannel;
            this._transferStarted = System.currentTimeMillis();
            this._httpMonitor.updateLastTransferred();
            if (!this._connectLatch.await(this._connectTimeout, TimeUnit.MILLISECONDS)) {
                this._httpMonitor.guardHasConnected();
            }
            while (!this._connectLatch.await(this._connectTimeout, TimeUnit.MILLISECONDS)) {
            }
        }
        finally {
            _logger.debug("Shutting down the mover: {}", (Object)uuid);
            _server.unregister(uuid);
            this._fileChannel = null;
        }
    }

    private void sendAddressToDoor(int port, UUID uuid, PnfsId pnfsId) throws SocketException, UnknownHostException, CacheException, SerializationException, NoRouteToCellException, URISyntaxException {
        String path = this._protocolInfo.getPath();
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        URI targetURI = null;
        InetAddress localIP = NetworkUtils.getLocalAddress((InetAddress)this._protocolInfo.getSocketAddress().getAddress());
        if (localIP != null && !localIP.isLoopbackAddress()) {
            targetURI = new URI(PROTOCOL_HTTP, null, localIP.getCanonicalHostName(), port, path, "dcache-http-uuid=" + uuid.toString(), null);
        } else {
            Enumeration<NetworkInterface> ifList = NetworkInterface.getNetworkInterfaces();
            while (ifList.hasMoreElements()) {
                NetworkInterface netif = ifList.nextElement();
                Enumeration<InetAddress> ips = netif.getInetAddresses();
                while (ips.hasMoreElements()) {
                    InetAddress addr = ips.nextElement();
                    if (addr.isLoopbackAddress()) continue;
                    targetURI = new URI(PROTOCOL_HTTP, null, localIP.getCanonicalHostName(), port, path, "dcache-http-uuid=" + uuid.toString(), null);
                }
            }
            if (targetURI == null) {
                throw new CacheException("Error: Cannot determine my ipaddress. Aborting transfer");
            }
        }
        _logger.info("Sending the following address to the WebDAV-door: {}", (Object)targetURI.toASCIIString());
        CellPath cellPath = new CellPath(this._protocolInfo.getHttpDoorCellName(), this._protocolInfo.getHttpDoorDomainName());
        HttpDoorUrlInfoMessage httpDoorMessage = new HttpDoorUrlInfoMessage(pnfsId.getId(), targetURI.toASCIIString());
        httpDoorMessage.setId(this._protocolInfo.getSessionId());
        this._endpoint.sendMessage(new CellMessage(cellPath, (Object)httpDoorMessage));
    }

    ChunkedInput read(URI requestedPath, long lowerRange, long upperRange) throws IOException, IllegalArgumentException, TimeoutCacheException {
        if (!this._httpMonitor.isInProgess()) {
            throw new TimeoutCacheException("Can not read from mover as it has shut down.");
        }
        this.checkRequestPath(requestedPath);
        ReusableChunkedNioFile content = null;
        long length = upperRange - lowerRange + 1L;
        content = new ReusableChunkedNioFile(this._fileChannel, lowerRange, length, this._chunkSize, this);
        return content;
    }

    void updateBytesTransferred(long length) {
        this._httpMonitor.updateBytesTransferred(length);
    }

    void updateLastTransferred() {
        this._httpMonitor.updateLastTransferred();
    }

    ChunkedInput read(URI requestedPath) throws IllegalArgumentException, IOException, TimeoutCacheException {
        return this.read(requestedPath, 0L, this._fileChannel.size() - 1L);
    }

    long getFileSize() throws IOException {
        return this._fileChannel.size();
    }

    String getFileName() {
        FsPath transferFile = new FsPath(this._protocolInfo.getPath());
        return transferFile.getName();
    }

    private void checkRequestPath(URI uri) throws IllegalArgumentException {
        FsPath transferFile;
        FsPath requestedFile = new FsPath(uri.getPath());
        if (!requestedFile.equals(transferFile = new FsPath(this._protocolInfo.getPath()))) {
            _logger.warn("Received an illegal request for file {}, while serving {}", (Object)requestedFile, (Object)transferFile);
            throw new IllegalArgumentException("The file you specified does not match the UUID you specified!");
        }
    }

    void open(HttpPoolRequestHandler handler) throws TimeoutCacheException {
        this._httpMonitor.connectHandler(handler);
    }

    void close(HttpPoolRequestHandler handler) {
        this._httpMonitor.disconnectHandlerToggleMover(handler);
    }

    @Override
    public long getBytesTransferred() {
        return this._httpMonitor.getBytesTransferred();
    }

    @Override
    public long getTransferTime() {
        return this._httpMonitor.isInProgess() ? System.currentTimeMillis() : this._httpMonitor.getLastTransferred() - this._transferStarted;
    }

    @Override
    public long getLastTransferred() {
        return this._httpMonitor.getLastTransferred();
    }

    @Override
    public boolean wasChanged() {
        return this._wasChanged;
    }

    static {
        _logger = LoggerFactory.getLogger(HttpProtocol_2.class);
    }

    private class HttpResourceMonitor {
        private long _lastTransferred;
        private long _bytesTransferred = 0L;
        private boolean _hasConnected = false;
        private final Set<HttpPoolRequestHandler> _connectedHandlers = new HashSet<HttpPoolRequestHandler>();
        private boolean _inProgress = false;

        private HttpResourceMonitor() {
        }

        synchronized void guardHasConnected() throws TimeoutCacheException {
            if (!this._hasConnected) {
                this._inProgress = false;
                _logger.warn("HTTP mover started, but no connection from HTTP client!");
                throw new TimeoutCacheException("No connection from HTTP client after " + TimeUnit.MILLISECONDS.toSeconds(HttpProtocol_2.this._connectTimeout) + " seconds. Giving up.");
            }
        }

        synchronized void updateLastTransferred() {
            this._lastTransferred = System.currentTimeMillis();
        }

        synchronized boolean isInProgess() {
            return this._inProgress;
        }

        synchronized void setInProgress(boolean inProgress) {
            this._inProgress = inProgress;
        }

        synchronized long getLastTransferred() {
            return this._lastTransferred;
        }

        synchronized long getBytesTransferred() {
            return this._bytesTransferred;
        }

        synchronized void updateBytesTransferred(long additional) {
            this._bytesTransferred += additional;
        }

        synchronized void connectHandler(HttpPoolRequestHandler handler) throws TimeoutCacheException {
            if (!this._inProgress) {
                throw new TimeoutCacheException("Can not open mover, as it is shutting down.");
            }
            this._hasConnected = true;
            this._connectedHandlers.add(handler);
        }

        synchronized void disconnectHandlerToggleMover(HttpPoolRequestHandler handler) {
            this._connectedHandlers.remove((Object)handler);
            if (this._connectedHandlers.isEmpty()) {
                this._inProgress = false;
                HttpProtocol_2.this._connectLatch.countDown();
            }
        }
    }
}

