/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.http;

import diskCacheV111.util.HttpByteRange;
import diskCacheV111.util.TimeoutCacheException;
import dmg.util.HttpException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.dcache.http.HttpPoolNettyServer;
import org.dcache.http.HttpProtocol_2;
import org.dcache.http.HttpRequestHandler;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.QueryStringDecoder;
import org.jboss.netty.handler.stream.ChunkedInput;
import org.jboss.netty.handler.timeout.IdleState;
import org.jboss.netty.handler.timeout.IdleStateEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpPoolRequestHandler
extends HttpRequestHandler {
    private static final Logger _logger = LoggerFactory.getLogger(HttpPoolRequestHandler.class);
    private final Set<HttpProtocol_2> _movers;
    HttpPoolNettyServer _executionServer;

    public HttpPoolRequestHandler(HttpPoolNettyServer executionServer) {
        this._executionServer = executionServer;
        this._movers = new HashSet<HttpProtocol_2>();
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent event) {
        _logger.debug("Called channelClosed.");
        for (HttpProtocol_2 mover : this._movers) {
            mover.close(this);
        }
        this._movers.clear();
    }

    public void channelIdle(ChannelHandlerContext ctx, IdleStateEvent event) throws Exception {
        if (event.getState() == IdleState.ALL_IDLE) {
            if (_logger.isInfoEnabled()) {
                long idleTime = System.currentTimeMillis() - event.getLastActivityTimeMillis();
                _logger.info("Closing idling connection without opened files. Connection has been idle for {} ms.", (Object)idleTime);
            }
            ctx.getChannel().close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doOnGet(ChannelHandlerContext context, MessageEvent event, HttpRequest request) {
        ChannelFuture future = null;
        HttpProtocol_2 mover = null;
        try {
            mover = this.getMoverForRequest(request);
            this._movers.add(mover);
            mover.open(this);
            long fileSize = mover.getFileSize();
            List<HttpByteRange> ranges = this.parseHttpRange(request, 0L, fileSize - 1L);
            URI path = new URI(request.getUri());
            if (ranges == null || ranges.isEmpty()) {
                ChunkedInput responseContent = mover.read(path);
                future = this.sendHTTPFullHeader(context, event, fileSize, mover.getFileName());
                future = event.getChannel().write((Object)responseContent);
            } else if (ranges.size() == 1) {
                HttpByteRange range = ranges.get(0);
                future = this.sendHTTPPartialHeader(context, event, range.getLower(), range.getUpper(), fileSize);
                ChunkedInput responseContent = mover.read(path, range.getLower(), range.getUpper());
                future = event.getChannel().write((Object)responseContent);
            } else {
                future = this.sendHTTPMultipartHeader(context, event);
                for (HttpByteRange range : ranges) {
                    ChunkedInput responseContent = mover.read(path, range.getLower(), range.getUpper());
                    this.sendHTTPMultipartFragment(context, event, range.getLower(), range.getUpper(), fileSize);
                    event.getChannel().write((Object)responseContent);
                }
                future = this.sendHTTPMultipartEnd(context, event);
            }
        }
        catch (HttpException e) {
            if (future == null) {
                future = this.sendHTTPError(context, HttpResponseStatus.valueOf((int)e.getErrorCode()), e.getMessage());
            } else {
                _logger.warn("Failure in HTTP GET: {}", (Object)e.getMessage());
                event.getChannel().close();
            }
        }
        catch (TimeoutCacheException e) {
            if (future == null) {
                future = this.sendHTTPError(context, HttpResponseStatus.REQUEST_TIMEOUT, e.getMessage());
            } else {
                _logger.warn("Failure in HTTP GET: {}", (Object)e.getMessage());
                event.getChannel().close();
            }
            this._movers.remove(mover);
        }
        catch (IllegalArgumentException e) {
            if (future == null) {
                future = this.sendHTTPError(context, HttpResponseStatus.BAD_REQUEST, e.getMessage());
            } else {
                _logger.warn("Failure in HTTP GET: {}", (Object)e.getMessage());
                event.getChannel().close();
            }
        }
        catch (IOException e) {
            if (future == null) {
                future = this.sendHTTPError(context, HttpResponseStatus.INTERNAL_SERVER_ERROR, e.getMessage());
            } else {
                _logger.warn("Failure in HTTP GET: {}", (Object)e.getMessage());
                event.getChannel().close();
            }
        }
        catch (RuntimeException e) {
            if (future == null) {
                future = this.sendHTTPError(context, HttpResponseStatus.INTERNAL_SERVER_ERROR, e.getMessage());
            } else {
                _logger.warn("Failure in HTTP GET: {}", (Object)e.getMessage());
                event.getChannel().close();
            }
        }
        catch (URISyntaxException e) {
            if (future == null) {
                future = this.sendHTTPError(context, HttpResponseStatus.BAD_REQUEST, "URI not valid: " + e.getMessage());
            } else {
                _logger.warn("Failure in HTTP GET: {}", (Object)e.getMessage());
                event.getChannel().close();
            }
        }
        finally {
            if (!this.isKeepAlive() && future != null) {
                future.addListener(ChannelFutureListener.CLOSE);
            }
        }
    }

    private HttpProtocol_2 getMoverForRequest(HttpRequest request) throws IllegalArgumentException {
        QueryStringDecoder queryStringDecoder = new QueryStringDecoder(request.getUri());
        Map params = queryStringDecoder.getParameters();
        if (!params.containsKey("dcache-http-uuid")) {
            if (!request.getUri().equals("/favicon.ico")) {
                _logger.error("Received request without UUID in the query string. Request-URI was {}", (Object)request.getUri());
            }
            throw new IllegalArgumentException("Query string does not include any UUID.");
        }
        List uuidList = (List)params.get("dcache-http-uuid");
        if (uuidList.size() < 1) {
            throw new IllegalArgumentException("UUID parameter does not include any value.");
        }
        UUID uuid = UUID.fromString((String)uuidList.get(0));
        HttpProtocol_2 mover = (HttpProtocol_2)this._executionServer.getMover(uuid);
        if (mover == null) {
            throw new IllegalArgumentException("Mover for UUID " + uuid + " timed out. " + "Please send new request to door.");
        }
        return mover;
    }
}

