/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.http;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.dcache.http.HttpPoolRequestHandler;
import org.dcache.http.HttpProtocol_2;
import org.dcache.pool.movers.AbstractNettyServer;
import org.dcache.util.PortRange;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.handler.codec.http.HttpChunkAggregator;
import org.jboss.netty.handler.codec.http.HttpContentCompressor;
import org.jboss.netty.handler.codec.http.HttpRequestDecoder;
import org.jboss.netty.handler.codec.http.HttpResponseEncoder;
import org.jboss.netty.handler.execution.ExecutionHandler;
import org.jboss.netty.handler.logging.LoggingHandler;
import org.jboss.netty.handler.stream.ChunkedWriteHandler;
import org.jboss.netty.handler.timeout.IdleStateHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpPoolNettyServer
extends AbstractNettyServer<HttpProtocol_2> {
    private static final Logger _logger = LoggerFactory.getLogger(HttpPoolNettyServer.class);
    private final int _maxChunkSize;
    private static final PortRange DEFAULT_PORTRANGE = new PortRange(20000, 25000);

    public HttpPoolNettyServer(int threadPoolSize, int memoryPerConnection, int maxMemory, int maxChunkSize, int clientIdleTimeout) {
        this(threadPoolSize, memoryPerConnection, maxMemory, maxChunkSize, clientIdleTimeout, -1);
    }

    public HttpPoolNettyServer(int threadPoolSize, int memoryPerConnection, int maxMemory, int maxChunkSize, int clientIdleTimeout, int socketThreads) {
        super(threadPoolSize, memoryPerConnection, maxMemory, clientIdleTimeout, socketThreads);
        this._maxChunkSize = maxChunkSize;
    }

    @Override
    protected ChannelPipelineFactory newPipelineFactory() {
        return new HttpPoolPipelineFactory();
    }

    @Override
    protected PortRange getPortRange() {
        String portRange = System.getProperty("org.globus.tcp.port.range");
        PortRange range = portRange != null ? PortRange.valueOf(portRange) : DEFAULT_PORTRANGE;
        return range;
    }

    @Override
    protected void toggleServer() throws IOException {
        if (this.isRunning() && this.getMoversPerUUID().isEmpty()) {
            this.stopServer();
            _logger.debug("No movers, no connections, stopping server.");
        } else if (!this.isRunning() && !this.getMoversPerUUID().isEmpty()) {
            _logger.debug("Starting server.");
            this.startServer();
        }
    }

    class HttpPoolPipelineFactory
    implements ChannelPipelineFactory {
        HttpPoolPipelineFactory() {
        }

        public ChannelPipeline getPipeline() throws Exception {
            ChannelPipeline pipeline = Channels.pipeline();
            pipeline.addLast("decoder", (ChannelHandler)new HttpRequestDecoder());
            pipeline.addLast("compressor", (ChannelHandler)new HttpContentCompressor());
            pipeline.addLast("aggregator", (ChannelHandler)new HttpChunkAggregator(HttpPoolNettyServer.this._maxChunkSize));
            pipeline.addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
            if (_logger.isDebugEnabled()) {
                pipeline.addLast("logger", (ChannelHandler)new LoggingHandler(HttpProtocol_2.class));
            }
            pipeline.addLast("executor", (ChannelHandler)new ExecutionHandler(HttpPoolNettyServer.this.getDiskExecutor()));
            pipeline.addLast("idle-state-handler", (ChannelHandler)new IdleStateHandler(HttpPoolNettyServer.this.getTimer(), 0L, 0L, HttpPoolNettyServer.this.getClientIdleTimeout(), TimeUnit.MILLISECONDS));
            pipeline.addLast("chunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
            pipeline.addLast("transfer", (ChannelHandler)new HttpPoolRequestHandler(HttpPoolNettyServer.this));
            return pipeline;
        }
    }
}

