/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.nfsv41.mover;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import org.dcache.auth.Subjects;
import org.dcache.chimera.FileSystemProvider;
import org.dcache.chimera.nfs.v4.AbstractNFSv4Operation;
import org.dcache.chimera.nfs.v4.HimeraNFS4Utils;
import org.dcache.chimera.nfs.v4.NFSServerV41;
import org.dcache.chimera.nfs.v4.NFSv4OperationFactory;
import org.dcache.chimera.nfs.v4.NfsIdMapping;
import org.dcache.chimera.nfs.v4.OperationCOMMIT;
import org.dcache.chimera.nfs.v4.OperationCREATE_SESSION;
import org.dcache.chimera.nfs.v4.OperationDESTROY_SESSION;
import org.dcache.chimera.nfs.v4.OperationEXCHANGE_ID;
import org.dcache.chimera.nfs.v4.OperationGETATTR;
import org.dcache.chimera.nfs.v4.OperationILLEGAL;
import org.dcache.chimera.nfs.v4.OperationPUTFH;
import org.dcache.chimera.nfs.v4.OperationPUTROOTFH;
import org.dcache.chimera.nfs.v4.OperationRECLAIM_COMPLETE;
import org.dcache.chimera.nfs.v4.OperationSEQUENCE;
import org.dcache.chimera.nfs.v4.ServerIdProvider;
import org.dcache.chimera.nfs.v4.SimpleIdMap;
import org.dcache.chimera.nfs.v4.xdr.nfs_argop4;
import org.dcache.chimera.nfs.v4.xdr.stateid4;
import org.dcache.chimera.nfsv41.mover.DummyFileSystemProvider;
import org.dcache.chimera.nfsv41.mover.EDSOperationREAD;
import org.dcache.chimera.nfsv41.mover.EDSOperationWRITE;
import org.dcache.chimera.nfsv41.mover.MoverBridge;
import org.dcache.util.PortRange;
import org.dcache.xdr.OncRpcException;
import org.dcache.xdr.OncRpcProgram;
import org.dcache.xdr.OncRpcSvc;
import org.dcache.xdr.OncRpcSvcBuilder;
import org.dcache.xdr.RpcLoginService;
import org.dcache.xdr.gss.GssSessionManager;
import org.ietf.jgss.GSSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NFSv4MoverHandler {
    private static final Logger _log = LoggerFactory.getLogger((String)NFSv4MoverHandler.class.getName());
    private final FileSystemProvider _fs = new DummyFileSystemProvider();
    private final OncRpcSvc _rpcService;
    private final Map<stateid4, MoverBridge> _activeIO = new HashMap<stateid4, MoverBridge>();
    private final NFSv4OperationFactory _operationFactory = new EDSNFSv4OperationFactory(this._activeIO);
    private final NFSServerV41 _embededDS;

    public NFSv4MoverHandler(PortRange portRange, boolean withGss, String serverId) throws IOException, OncRpcException, GSSException {
        ServerIdProvider idProvider = HimeraNFS4Utils.cellNameToServerIdProvider((String)serverId);
        this._embededDS = new NFSServerV41(this._operationFactory, null, null, this._fs, (NfsIdMapping)new SimpleIdMap(), null, idProvider);
        this._rpcService = new OncRpcSvcBuilder().withMinPort(portRange.getLower()).withMaxPort(portRange.getUpper()).withTCP().withoutAutoPublish().withSameThreadIoStrategy().build();
        HashMap<OncRpcProgram, NFSServerV41> programs = new HashMap<OncRpcProgram, NFSServerV41>();
        programs.put(new OncRpcProgram(100003, 4), this._embededDS);
        this._rpcService.setPrograms(programs);
        if (withGss) {
            RpcLoginService rpcLoginService = new RpcLoginService(){

                public Subject login(Principal principal) {
                    return Subjects.NOBODY;
                }
            };
            GssSessionManager gss = new GssSessionManager(rpcLoginService);
            this._rpcService.setGssSessionManager(gss);
        }
        this._rpcService.start();
    }

    public void addHandler(MoverBridge moverBridge) {
        _log.debug("added io handler: {}", (Object)moverBridge);
        this._activeIO.put(moverBridge.getStateid(), moverBridge);
    }

    public void removeHandler(MoverBridge moverBridge) {
        _log.debug("removing io handler: {}", (Object)moverBridge);
        this._activeIO.remove(moverBridge.getStateid());
    }

    public InetSocketAddress getLocalAddress() {
        return this._rpcService.getInetSocketAddress(6);
    }

    public void shutdown() throws IOException {
        this._rpcService.stop();
    }

    private static class EDSNFSv4OperationFactory
    implements NFSv4OperationFactory {
        private final Map<stateid4, MoverBridge> _activeIO;

        EDSNFSv4OperationFactory(Map<stateid4, MoverBridge> activeIO) {
            this._activeIO = activeIO;
        }

        public AbstractNFSv4Operation getOperation(nfs_argop4 op) {
            switch (op.argop) {
                case 5: {
                    return new OperationCOMMIT(op);
                }
                case 9: {
                    return new OperationGETATTR(op);
                }
                case 22: {
                    return new OperationPUTFH(op);
                }
                case 24: {
                    return new OperationPUTROOTFH(op);
                }
                case 25: {
                    return new EDSOperationREAD(op, this._activeIO);
                }
                case 38: {
                    return new EDSOperationWRITE(op, this._activeIO);
                }
                case 42: {
                    return new OperationEXCHANGE_ID(op, 262144);
                }
                case 43: {
                    return new OperationCREATE_SESSION(op);
                }
                case 44: {
                    return new OperationDESTROY_SESSION(op);
                }
                case 53: {
                    return new OperationSEQUENCE(op);
                }
                case 58: {
                    return new OperationRECLAIM_COMPLETE(op);
                }
            }
            return new OperationILLEGAL(op);
        }
    }
}

