/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.nfsv41.mover;

import diskCacheV111.util.PnfsId;
import diskCacheV111.vehicles.ProtocolInfo;
import diskCacheV111.vehicles.StorageInfo;
import dmg.cells.nucleus.CellEndpoint;
import org.dcache.pool.movers.IoMode;
import org.dcache.pool.movers.ManualMover;
import org.dcache.pool.repository.Allocator;
import org.dcache.pool.repository.RepositoryChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NFSv41ProtocolMover
implements ManualMover {
    private final CellEndpoint _cell;
    private long _bytesTransferred = 0L;
    private long _lastAccessTime = 0L;
    private long _started = 0L;
    private IoMode _ioMode = IoMode.READ;
    private static final Logger _log = LoggerFactory.getLogger(NFSv41ProtocolMover.class);

    public NFSv41ProtocolMover(CellEndpoint cell) {
        this._cell = cell;
    }

    @Override
    public long getBytesTransferred() {
        return this._bytesTransferred;
    }

    @Override
    public long getLastTransferred() {
        return this._lastAccessTime;
    }

    @Override
    public long getTransferTime() {
        if (this._started == 0L) {
            return 0L;
        }
        return System.currentTimeMillis() - this._started;
    }

    @Override
    public void runIO(RepositoryChannel raf, ProtocolInfo protocol, StorageInfo storage, PnfsId pnfsId, Allocator allocator, IoMode access) throws Exception {
        throw new RuntimeException("This mover it not suposed to run in legacy mode");
    }

    @Override
    public boolean wasChanged() {
        return this._ioMode == IoMode.WRITE && this.getBytesTransferred() > 0L;
    }

    @Override
    public void setBytesTransferred(long bytesTransferred) {
        if (bytesTransferred < 0L) {
            return;
        }
        this._bytesTransferred += bytesTransferred;
        this._lastAccessTime = System.currentTimeMillis();
        if (this._started == 0L) {
            this._started = this._lastAccessTime;
        }
    }
}

