/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.chimera.nfsv41.door;

import java.io.IOException;
import org.dcache.chimera.FileSystemProvider;
import org.dcache.chimera.nfs.ExportFile;
import org.dcache.chimera.nfs.v3.MountServer;
import org.dcache.chimera.nfs.v3.NfsServerV3;
import org.dcache.xdr.OncRpcProgram;
import org.dcache.xdr.OncRpcSvc;
import org.dcache.xdr.RpcDispatchable;
import org.dcache.xdr.portmap.OncRpcEmbeddedPortmap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NFSv3 {
    private static final Logger _log = LoggerFactory.getLogger(NFSv3.class);
    private FileSystemProvider _fs;
    private ExportFile _exports;
    private OncRpcSvc _service;
    private int _port;

    public void init() throws Exception {
        _log.info("starting NFSv3 on: {}", (Object)this._port);
        new OncRpcEmbeddedPortmap();
        NfsServerV3 nfs3 = new NfsServerV3(this._exports, this._fs);
        MountServer ms = new MountServer(this._exports, this._fs);
        this._service = new OncRpcSvc(this._port);
        this._service.register(new OncRpcProgram(100003, 3), (RpcDispatchable)nfs3);
        this._service.register(new OncRpcProgram(100005, 3), (RpcDispatchable)ms);
        this._service.start();
    }

    public void destroy() throws IOException {
        this._service.stop();
    }

    public void setFileSystemProvider(FileSystemProvider fs) {
        this._fs = fs;
    }

    public void setExportFile(ExportFile export) {
        this._exports = export;
    }

    public void setPortNumber(int port) {
        this._port = port;
    }
}

