/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.cells;

import diskCacheV111.util.CacheException;
import diskCacheV111.vehicles.Message;
import dmg.cells.nucleus.CellEndpoint;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.NoRouteToCellException;
import dmg.cells.nucleus.Reply;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.dcache.util.CacheExceptionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageReply<T extends Message>
implements Reply,
Future<T> {
    private static final Logger _logger = LoggerFactory.getLogger(MessageReply.class);
    private CellEndpoint _endpoint;
    private CellMessage _envelope;
    private T _msg;

    public synchronized void deliver(CellEndpoint endpoint, CellMessage envelope) {
        if (endpoint == null || envelope == null) {
            throw new NullPointerException("Arguments must not be null");
        }
        this._endpoint = endpoint;
        this._envelope = envelope;
        if (this._msg != null) {
            this.send();
        }
    }

    public boolean isValidIn(long delay) {
        return this._envelope == null || delay <= this._envelope.getTtl() - this._envelope.getLocalAge();
    }

    public void fail(T msg, Exception e) {
        if (e instanceof CacheException) {
            CacheException ce = (CacheException)e;
            this.fail(msg, ce.getRc(), ce.getMessage());
        } else if (e instanceof IllegalArgumentException) {
            this.fail(msg, 10015, e.getMessage());
        } else {
            this.fail(msg, 10011, e);
        }
    }

    public void fail(T msg, int rc, Object e) {
        ((Message)msg).setFailed(rc, e);
        this.reply(msg);
    }

    public synchronized void reply(T msg) {
        this._msg = msg;
        ((Message)this._msg).setReply();
        if (this._envelope != null) {
            this.send();
        }
        this.notifyAll();
    }

    protected void onNoRouteToCell(NoRouteToCellException e) {
        _logger.error("Failed to send reply: " + e.getMessage());
    }

    protected synchronized void send() {
        try {
            this._envelope.setMessageObject(this._msg);
            this._endpoint.sendMessage(this._envelope);
        }
        catch (NoRouteToCellException e) {
            this.onNoRouteToCell(e);
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    private synchronized T get(T msg) throws ExecutionException {
        if (((Message)msg).getReturnCode() != 0) {
            Object o = ((Message)msg).getErrorObject();
            Exception e = o instanceof Exception ? (Exception)o : CacheExceptionFactory.exceptionOf(((Message)msg).getReturnCode(), String.valueOf(o));
            throw new ExecutionException(e.getMessage(), e);
        }
        return msg;
    }

    @Override
    public synchronized T get() throws InterruptedException, ExecutionException {
        while (this._msg == null) {
            this.wait();
        }
        return this.get(this._msg);
    }

    @Override
    public synchronized T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long expirationTime = System.currentTimeMillis() + unit.toMillis(timeout);
        while (this._msg == null) {
            long timeLeft = expirationTime - System.currentTimeMillis();
            if (timeLeft <= 0L) {
                throw new TimeoutException();
            }
            unit.timedWait(this, timeLeft);
        }
        return this.get(this._msg);
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public synchronized boolean isDone() {
        return this._msg != null;
    }
}

