/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.cells;

import diskCacheV111.vehicles.Message;
import dmg.cells.nucleus.CellEndpoint;
import dmg.cells.nucleus.CellInfo;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellMessageAnswerable;
import dmg.cells.nucleus.NoRouteToCellException;
import dmg.cells.nucleus.SerializationException;
import dmg.util.Args;
import java.util.Map;
import org.dcache.cells.CellCommandListener;
import org.dcache.cells.CellMessageSender;
import org.dcache.commons.stats.RequestCounters;
import org.dcache.commons.stats.RequestExecutionTimeGauges;

public class MessageProcessingMonitor
implements CellCommandListener,
CellMessageSender {
    private final RequestCounters<Class> _counters = new RequestCounters("Messages");
    private final RequestExecutionTimeGauges<Class> _gauges = new RequestExecutionTimeGauges("Messages");
    private CellEndpoint _endpoint;
    private boolean _enabled = false;
    public static final String hh_monitoring_enable = "# Enables monitoring of message processing";
    public static final String hh_monitoring_disable = "# Disables monitoring of message processing";
    public static final String hh_monitoring_info = "# Provides information about message processing";

    @Override
    public void setCellEndpoint(CellEndpoint endpoint) {
        this._endpoint = endpoint;
    }

    public void setEnabled(boolean enabled) {
        this._enabled = enabled;
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public CellEndpoint getReplyCellEndpoint(CellMessage envelope) {
        if (this._enabled) {
            Class<?> type = envelope.getMessageObject().getClass();
            return new MonitoringReplyCellEndpoint(type);
        }
        return this._endpoint;
    }

    public String ac_monitoring_enable(Args args) {
        this._enabled = true;
        return "";
    }

    public String ac_monitoring_disable(Args args) {
        this._enabled = false;
        return "";
    }

    public String ac_monitoring_info(Args args) {
        return this._counters.toString() + "\n\n" + this._gauges.toString();
    }

    public class MonitoringReplyCellEndpoint
    implements CellEndpoint {
        private final Class _type;
        private final long _startTime = System.currentTimeMillis();

        public MonitoringReplyCellEndpoint(Class type) {
            this._type = type;
            MessageProcessingMonitor.this._counters.incrementRequests((Object)this._type);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sendMessage(CellMessage envelope) throws SerializationException, NoRouteToCellException {
            boolean success = false;
            try {
                MessageProcessingMonitor.this._endpoint.sendMessage(envelope);
                success = true;
            }
            finally {
                MessageProcessingMonitor.this._gauges.update((Object)this._type, System.currentTimeMillis() - this._startTime);
                Object o = envelope.getMessageObject();
                if (!success || o instanceof Exception || o instanceof Message && ((Message)o).getReturnCode() != 0) {
                    MessageProcessingMonitor.this._counters.incrementFailed((Object)this._type);
                }
            }
        }

        public void sendMessage(CellMessage envelope, CellMessageAnswerable callback, long timeout) {
            throw new UnsupportedOperationException("Cannot use callback for reply");
        }

        public CellMessage sendAndWait(CellMessage envelope, long timeout) {
            throw new UnsupportedOperationException("Cannot use blocking send for reply");
        }

        public CellMessage sendAndWaitToPermanent(CellMessage envelope, long timeout) {
            throw new UnsupportedOperationException("Cannot use blocking send for reply");
        }

        public CellInfo getCellInfo() {
            return MessageProcessingMonitor.this._endpoint.getCellInfo();
        }

        public Map<String, Object> getDomainContext() {
            return MessageProcessingMonitor.this._endpoint.getDomainContext();
        }

        public Args getArgs() {
            return MessageProcessingMonitor.this._endpoint.getArgs();
        }
    }
}

