/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.cells;

import dmg.cells.nucleus.CellMessage;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.dcache.util.ReflectionUtils;

public class CellMessageDispatcher {
    private final Map<Class, Collection<Receiver>> _receivers = new HashMap<Class, Collection<Receiver>>();
    private final String _receiverName;
    private final Collection<Object> _messageListeners = new CopyOnWriteArrayList<Object>();

    public CellMessageDispatcher(String receiverName) {
        this._receiverName = receiverName;
    }

    private boolean hasListener(Class c) {
        for (Method m : c.getMethods()) {
            if (!m.getName().equals(this._receiverName)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessageListener(Object o) {
        Class<?> c = o.getClass();
        if (this.hasListener(c)) {
            Map<Class, Collection<Receiver>> map = this._receivers;
            synchronized (map) {
                if (this._messageListeners.add(o)) {
                    this._receivers.clear();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessageListener(Object o) {
        Map<Class, Collection<Receiver>> map = this._receivers;
        synchronized (map) {
            if (this._messageListeners.remove(o)) {
                this._receivers.clear();
            }
        }
    }

    public Collection<Class> getMessageTypes(Object o) {
        Class<?> c = o.getClass();
        ArrayList<Class> types = new ArrayList<Class>();
        block4: for (Method method : c.getMethods()) {
            if (!method.getName().equals(this._receiverName)) continue;
            Class<?>[] parameterTypes = method.getParameterTypes();
            switch (parameterTypes.length) {
                case 1: {
                    types.add(parameterTypes[0]);
                    continue block4;
                }
                case 2: {
                    if (!CellMessage.class.isAssignableFrom(parameterTypes[0])) continue block4;
                    types.add(parameterTypes[1]);
                }
            }
        }
        return types;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<Receiver> findReceivers(Class c) {
        Map<Class, Collection<Receiver>> map = this._receivers;
        synchronized (map) {
            ArrayList<Receiver> receivers = new ArrayList<Receiver>();
            for (Object listener : this._messageListeners) {
                Method m = ReflectionUtils.resolve(listener.getClass(), this._receiverName, CellMessage.class, c);
                if (m != null) {
                    m.setAccessible(true);
                    receivers.add(new LongReceiver(listener, m));
                    continue;
                }
                m = ReflectionUtils.resolve(listener.getClass(), this._receiverName, c);
                if (m == null) continue;
                m.setAccessible(true);
                receivers.add(new ShortReceiver(listener, m));
            }
            return receivers;
        }
    }

    private String multipleRepliesError(Collection<Receiver> receivers, Object message) {
        return String.format("Processing of message [%s] of type %s failed: Multiple replies were generated by %s.", message, message.getClass().getName(), receivers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object call(CellMessage envelope) {
        Collection<Receiver> receivers;
        Object message = envelope.getMessageObject();
        Class<?> c = message.getClass();
        Map<Class, Collection<Receiver>> map = this._receivers;
        synchronized (map) {
            receivers = this._receivers.get(c);
            if (receivers == null) {
                receivers = this.findReceivers(c);
                this._receivers.put(c, receivers);
            }
        }
        Object result = null;
        for (Receiver receiver : receivers) {
            try {
                Object obj = receiver.deliver(envelope, message);
                if (obj == null) continue;
                if (result != null) {
                    throw new RuntimeException(this.multipleRepliesError(receivers, message));
                }
                result = obj;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Cannot process message due to access error", e);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (!(cause instanceof IllegalArgumentException || cause instanceof IllegalStateException || receiver.isDeclaredToThrow(cause.getClass()))) {
                    if (cause instanceof RuntimeException) {
                        throw (RuntimeException)cause;
                    }
                    if (cause instanceof Error) {
                        throw (Error)cause;
                    }
                    throw new RuntimeException("Bug: This should have been unreachable. Please report to support@dcache.org.", cause);
                }
                if (result != null) {
                    throw new RuntimeException(this.multipleRepliesError(receivers, message));
                }
                result = cause;
            }
        }
        return result;
    }

    static class LongReceiver
    extends Receiver {
        public LongReceiver(Object object, Method method) {
            super(object, method);
        }

        @Override
        public Object deliver(CellMessage envelope, Object message) throws IllegalAccessException, InvocationTargetException {
            return this._method.invoke(this._object, envelope, message);
        }
    }

    static class ShortReceiver
    extends Receiver {
        public ShortReceiver(Object object, Method method) {
            super(object, method);
        }

        @Override
        public Object deliver(CellMessage envelope, Object message) throws IllegalAccessException, InvocationTargetException {
            return this._method.invoke(this._object, message);
        }
    }

    static abstract class Receiver {
        protected final Object _object;
        protected final Method _method;

        public Receiver(Object object, Method method) {
            this._object = object;
            this._method = method;
        }

        public abstract Object deliver(CellMessage var1, Object var2) throws IllegalAccessException, InvocationTargetException;

        public String toString() {
            return String.format("Object: %1$s; Method: %2$s", this._object, this._method);
        }

        public boolean isDeclaredToThrow(Class<?> exceptionClass) {
            for (Class<?> clazz : this._method.getExceptionTypes()) {
                if (!clazz.isAssignableFrom(exceptionClass)) continue;
                return true;
            }
            return false;
        }
    }
}

