/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.boot;

import java.io.PrintStream;
import java.util.Enumeration;
import org.dcache.boot.Layout;
import org.dcache.boot.LayoutPrinter;
import org.dcache.util.ConfigurationProperties;

public class XmlEntityLayoutPrinter
implements LayoutPrinter {
    private final Layout _layout;
    private final String[] _prefixes;

    public XmlEntityLayoutPrinter(Layout layout, String ... prefixes) {
        this._layout = layout;
        this._prefixes = prefixes;
    }

    @Override
    public void print(PrintStream out) {
        ConfigurationProperties properties = this._layout.properties();
        Enumeration<?> propertyNames = properties.propertyNames();
        while (propertyNames.hasMoreElements()) {
            String key = (String)propertyNames.nextElement();
            if (!this.isToBePrinted(key)) continue;
            String value = properties.getValue(key);
            out.println("<!ENTITY " + XmlEntityLayoutPrinter.entityNameFrom(key) + " \"" + XmlEntityLayoutPrinter.entityValueFrom(value) + "\">");
        }
    }

    private boolean isToBePrinted(String key) {
        if (ConfigurationProperties.isScoped(key)) {
            return false;
        }
        boolean printEntity = this._prefixes.length == 0;
        for (String prefix : this._prefixes) {
            if (!key.startsWith(prefix)) continue;
            printEntity = true;
            break;
        }
        return printEntity;
    }

    private static String entityNameFrom(String key) {
        StringBuilder sb = new StringBuilder();
        char first = key.charAt(0);
        sb.append(XmlEntityLayoutPrinter.isValidEntityNameStartCharacter(first) ? Character.valueOf(first) : "_");
        for (int i = 1; i < key.length(); ++i) {
            char c = key.charAt(i);
            sb.append(XmlEntityLayoutPrinter.isValidEntityNameCharacter(c) ? Character.valueOf(c) : "_");
        }
        return sb.toString();
    }

    private static boolean isValidEntityNameStartCharacter(char c) {
        if (XmlEntityLayoutPrinter.hasCharType(c, 2, 1)) {
            return true;
        }
        return c == '_';
    }

    private static boolean isValidEntityNameCharacter(char c) {
        if (XmlEntityLayoutPrinter.hasCharType(c, 2, 1, 9)) {
            return true;
        }
        return c == '-' || c == '.';
    }

    private static boolean hasCharType(char c, int ... types) {
        int charType = Character.getType(c);
        for (int i = 0; i < types.length; ++i) {
            if (charType != types[i]) continue;
            return true;
        }
        return false;
    }

    private static String entityValueFrom(String s) {
        return s.replace("&", "&amp;").replace("\"", "&quot;").replace("'", "&apos;").replace("<", "&lt;");
    }
}

