/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.boot;

import java.io.PrintStream;
import org.dcache.boot.Domain;
import org.dcache.boot.Layout;
import org.dcache.boot.LayoutPrinter;
import org.dcache.util.ConfigurationProperties;
import org.dcache.util.ScopedConfigurationProperties;

public class ShellOracleLayoutPrinter
implements LayoutPrinter {
    private final Layout _layout;

    public ShellOracleLayoutPrinter(Layout layout) {
        this._layout = layout;
    }

    @Override
    public void print(PrintStream out) {
        out.println("getProperty()");
        out.println("{");
        out.println("  case \"$2\" in");
        out.println("    \"\")");
        out.println("      ;;");
        for (Domain domain : this._layout.getDomains()) {
            out.append("    ").append(ShellOracleLayoutPrinter.quoteForCase(domain.getName())).println(")");
            out.println("      case \"$3\" in");
            out.println("        \"\")");
            out.println("          ;;");
            for (ScopedConfigurationProperties service : domain.getServices()) {
                String cellName = service.getValue("cell.name");
                if (cellName == null) continue;
                out.append("        ").append(ShellOracleLayoutPrinter.quoteForCase(cellName)).println(")");
                ShellOracleLayoutPrinter.compile(out, "          ", service, domain.properties());
                out.println("          ;;");
            }
            out.println("        *)");
            out.println("          undefinedCell \"$@\"");
            out.println("          ;;");
            out.println("      esac");
            out.println("      ;;");
        }
        out.println("    *)");
        out.println("      undefinedDomain \"$@\"");
        out.println("      ;;");
        out.println("  esac");
        out.println();
        out.println("  case \"$2\" in");
        for (Domain domain : this._layout.getDomains()) {
            out.append("    ").append(ShellOracleLayoutPrinter.quoteForCase(domain.getName())).println(")");
            ShellOracleLayoutPrinter.compile(out, "      ", domain.properties(), this._layout.properties());
            out.println("      ;;");
        }
        out.println("  esac");
        out.println();
        ShellOracleLayoutPrinter.compile(out, "  ", this._layout.properties(), new ConfigurationProperties());
        out.println();
        out.println("  undefinedProperty \"$@\"");
        out.println("}");
    }

    private static String quote(String s) {
        return s.replace("\\", "\\\\").replace("$", "\\$").replace("`", "\\`").replace("\"", "\\\"");
    }

    private static String quoteForCase(String s) {
        return ShellOracleLayoutPrinter.quote(s).replace(")", "\\)").replace("?", "\\?").replace("*", "\\*").replace("[", "\\[");
    }

    private static void compile(PrintStream out, String indent, ConfigurationProperties properties, ConfigurationProperties parentProperties) {
        out.append(indent).println("case \"$1\" in");
        for (String key : properties.stringPropertyNames()) {
            String value;
            if (ScopedConfigurationProperties.isScoped(key) || (value = properties.getValue(key)).equals(parentProperties.getValue(key))) continue;
            out.append(indent).append("  ");
            out.append(ShellOracleLayoutPrinter.quoteForCase(key)).append(") echo \"");
            out.append(ShellOracleLayoutPrinter.quote(value.trim()));
            out.println("\"; return;;");
        }
        out.append(indent).println("esac");
    }
}

