/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.boot;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.util.StatusPrinter;
import com.google.common.base.Joiner;
import dmg.cells.nucleus.CDC;
import dmg.cells.nucleus.CellShell;
import dmg.cells.nucleus.SystemCell;
import dmg.util.Args;
import dmg.util.CommandException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.dcache.util.ConfigurationProperties;
import org.dcache.util.NetworkUtils;
import org.dcache.util.ScopedConfigurationProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Domain {
    private static final String SYSTEM_CELL_NAME = "System";
    private static final String SCHEME_FILE = "file";
    private static final Logger _log = LoggerFactory.getLogger(SystemCell.class);
    private final ConfigurationProperties _properties;
    private final List<ScopedConfigurationProperties> _services;

    public Domain(String name, ConfigurationProperties defaults) {
        this._properties = new ConfigurationProperties(defaults);
        this._properties.put("domain.name", name);
        this._services = new ArrayList<ScopedConfigurationProperties>();
    }

    public ConfigurationProperties properties() {
        this._properties.put("domain.cells", Joiner.on((String)" ").join(this.getCellNames()));
        return this._properties;
    }

    public List<String> getCellNames() {
        ArrayList<String> cells = new ArrayList<String>();
        for (ScopedConfigurationProperties service : this._services) {
            String cellName = service.getValue("cell.name");
            if (cellName == null) continue;
            cells.add(cellName);
        }
        return cells;
    }

    public ConfigurationProperties createService(String name) {
        ScopedConfigurationProperties service = new ScopedConfigurationProperties(this._properties, name);
        service.setIsService(true);
        service.put("domain.service", name);
        this._services.add(service);
        return service;
    }

    public String getName() {
        return this._properties.getValue("domain.name");
    }

    List<ScopedConfigurationProperties> getServices() {
        return this._services;
    }

    public void start() throws URISyntaxException, CommandException, IOException {
        this.initializeLogging();
        String domainName = this.getName();
        CDC.reset((String)SYSTEM_CELL_NAME, (String)domainName);
        SystemCell systemCell = new SystemCell(domainName);
        _log.info("Starting " + domainName);
        this.executePreload(systemCell);
        for (ScopedConfigurationProperties serviceConfig : this._services) {
            this.executeService(systemCell, serviceConfig);
        }
        if (this._services.isEmpty()) {
            _log.warn("No services found. Domain appears to be empty.");
        }
    }

    private URI getLogConfigurationUri() throws URISyntaxException {
        String property = this._properties.getValue("dcache.log.configuration");
        if (property == null) {
            return null;
        }
        URI uri = new URI(property);
        String path = uri.getPath();
        if (path == null) {
            throw new URISyntaxException(property, "Path is missing");
        }
        if (uri.getScheme() == null || uri.getScheme().equals(SCHEME_FILE)) {
            File f = new File(path);
            uri = f.toURI();
        }
        return uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeLogging() throws URISyntaxException, IOException {
        try {
            URI uri = this.getLogConfigurationUri();
            if (uri == null) {
                return;
            }
            LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
            loggerContext.reset();
            for (String key : this._properties.stringPropertyNames()) {
                if (ScopedConfigurationProperties.isScoped(key)) continue;
                loggerContext.putProperty(key, this._properties.getProperty(key));
            }
            try {
                JoranConfigurator configurator = new JoranConfigurator();
                configurator.setContext((Context)loggerContext);
                configurator.doConfigure(NetworkUtils.toURL((URI)uri));
            }
            finally {
                StatusPrinter.printInCaseOfErrorsOrWarnings((Context)loggerContext);
            }
        }
        catch (JoranException e) {
            throw new IOException("Failed to load log configuration:" + e.getMessage(), e);
        }
    }

    private void importParameters(Map<String, Object> map, ConfigurationProperties properties) {
        for (String key : properties.stringPropertyNames()) {
            if (ScopedConfigurationProperties.isScoped(key)) continue;
            map.put(key, properties.getProperty(key));
        }
    }

    private void executePreload(SystemCell cell) throws URISyntaxException, IOException, CommandException {
        String preload = this._properties.getValue("domain.preload");
        if (preload != null) {
            CellShell shell = new CellShell(cell.getNucleus());
            this.importParameters(shell.environment(), this._properties);
            this.executeBatchFile(shell, new URI(preload));
        }
    }

    CellShell createShellForService(SystemCell system, ConfigurationProperties properties) throws CommandException {
        CellShell shell = new CellShell(system.getNucleus());
        this.importParameters(shell.environment(), properties);
        return shell;
    }

    private void executeService(SystemCell system, ConfigurationProperties properties) throws URISyntaxException, IOException, CommandException {
        CellShell shell = this.createShellForService(system, properties);
        URI uri = this.findBatchFile(properties);
        this.executeBatchFile(shell, uri);
    }

    private URI findBatchFile(ConfigurationProperties properties) throws URISyntaxException {
        String name = properties.getValue("domain.service.uri");
        URI uri = new URI(name);
        if (uri.isAbsolute()) {
            return uri;
        }
        File file = new File(uri.getPath());
        if (file.isAbsolute()) {
            return file.toURI();
        }
        String pluginPath = properties.getValue("dcache.paths.plugins");
        for (String s : pluginPath.split(":")) {
            File dir = new File(s);
            if (!dir.isDirectory()) continue;
            for (File plugin : dir.listFiles()) {
                file = new File(plugin, name);
                if (!file.exists()) continue;
                return file.toURI();
            }
        }
        URI base = new URI(properties.getValue("domain.service.uri.base"));
        return base.resolve(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeBatchFile(CellShell shell, URI resource) throws URISyntaxException, IOException, CommandException {
        InputStream input = NetworkUtils.toURL((URI)resource).openStream();
        try {
            shell.execute(resource.toString(), (Reader)new InputStreamReader(input), new Args((CharSequence)""));
        }
        finally {
            input.close();
        }
    }
}

