/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.boot;

import com.google.common.base.Strings;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Map;
import org.dcache.boot.Domain;
import org.dcache.boot.Layout;
import org.dcache.boot.LayoutPrinter;
import org.dcache.util.ConfigurationProperties;
import org.dcache.util.ScopedConfigurationProperties;

public class DebugLayoutPrinter
implements LayoutPrinter {
    private final Layout _layout;
    private PrintStream _out;

    public DebugLayoutPrinter(Layout layout) {
        this._layout = layout;
    }

    @Override
    public void print(PrintStream out) {
        this._out = out;
        out.println("#        --- DEFAULTS ---\n");
        this.listDefaults(this._layout.properties());
        out.println("\n#        --- CONFIGURATION ---\n");
        this.listProperties(this._layout.properties(), "", 0);
        for (Domain domain : this._layout.getDomains()) {
            this.listProperties(domain.properties(), "[" + domain.getName() + "]", 2);
            for (ScopedConfigurationProperties properties : domain.getServices()) {
                this.listProperties(properties, "[" + domain.getName() + "/" + properties.getScope() + "]", 2);
            }
        }
    }

    private void listDefaults(ConfigurationProperties properties) {
        Enumeration<?> propertyNames = properties.propertyNames();
        while (propertyNames.hasMoreElements()) {
            String key = (String)propertyNames.nextElement();
            if (properties.contains(key)) continue;
            this.showProperty(properties, 0, key);
        }
    }

    private void listProperties(ConfigurationProperties properties, String label, int indent) {
        this._out.println();
        if (!label.isEmpty()) {
            this._out.println(Strings.padStart((String)label, (int)indent, (char)' '));
        }
        int assignmentIndent = indent > 0 ? indent + 1 : 0;
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            this.showProperty(properties, assignmentIndent, key);
        }
    }

    private void showProperty(ConfigurationProperties properties, int indent, String key) {
        String rawValue = properties.getProperty(key);
        this._out.format("%s = %s\n", Strings.padStart((String)key, (int)(indent + key.length()), (char)' '), rawValue);
        String value = properties.getValue(key);
        if (!rawValue.equals(value)) {
            this._out.format("#%s\n", Strings.padStart((String)value, (int)(indent + key.length() + 2 + value.length()), (char)' '));
        }
    }
}

