/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.auth;

import diskCacheV111.util.CacheException;
import diskCacheV111.util.PermissionDeniedCacheException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.security.auth.Subject;
import org.dcache.auth.LoginReply;
import org.dcache.auth.LoginStrategy;
import org.dcache.auth.Subjects;
import org.dcache.auth.attributes.LoginAttribute;
import org.dcache.auth.attributes.ReadOnly;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnionLoginStrategy
implements LoginStrategy {
    private static final Logger _log = LoggerFactory.getLogger(UnionLoginStrategy.class);
    private List<LoginStrategy> _loginStrategies = Collections.emptyList();
    private AccessLevel _anonymousAccess = AccessLevel.NONE;

    public void setLoginStrategies(List<LoginStrategy> list) {
        this._loginStrategies = new ArrayList<LoginStrategy>(list);
    }

    public List<LoginStrategy> getLoginStrategies() {
        return Collections.unmodifiableList(this._loginStrategies);
    }

    public void setAnonymousAccess(AccessLevel level) {
        _log.debug("Setting anonymous access to {}", (Object)level);
        this._anonymousAccess = level;
    }

    public AccessLevel getAnonymousAccess() {
        return this._anonymousAccess;
    }

    @Override
    public LoginReply login(Subject subject) throws CacheException {
        for (LoginStrategy strategy : this._loginStrategies) {
            _log.debug("Attempting login strategy: {}", (Object)strategy.getClass().getName());
            try {
                LoginReply login = strategy.login(subject);
                _log.debug("Login strategy returned {}", (Object)login.getSubject());
                if (Subjects.isNobody((Subject)login.getSubject())) continue;
                return login;
            }
            catch (IllegalArgumentException e) {
                _log.debug("Login failed with IllegalArgumentException for {}: {}", (Object)subject, (Object)e.getMessage());
            }
            catch (PermissionDeniedCacheException e) {
                _log.debug("Permission denied for {}: {}", (Object)subject, (Object)e.getMessage());
            }
        }
        _log.debug("Strategies failed, trying for anonymous access");
        switch (this._anonymousAccess) {
            case READONLY: {
                _log.debug("Allowing read-only access as an anonymous user");
                LoginReply reply = new LoginReply();
                reply.getLoginAttributes().add((LoginAttribute)new ReadOnly(true));
                return reply;
            }
            case FULL: {
                _log.debug("Allowing full access as an anonymous user");
                return new LoginReply();
            }
        }
        _log.debug("Login failed");
        throw new PermissionDeniedCacheException("Access denied");
    }

    @Override
    public Principal map(Principal principal) throws CacheException {
        for (LoginStrategy strategy : this._loginStrategies) {
            Principal result = strategy.map(principal);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public Set<Principal> reverseMap(Principal principal) throws CacheException {
        HashSet<Principal> result = new HashSet<Principal>();
        for (LoginStrategy strategy : this._loginStrategies) {
            result.addAll(strategy.reverseMap(principal));
        }
        return result;
    }

    public static enum AccessLevel {
        NONE,
        READONLY,
        FULL;

    }
}

