/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.auth;

import diskCacheV111.util.CacheException;
import diskCacheV111.util.PermissionDeniedCacheException;
import java.io.File;
import java.io.IOException;
import java.security.Principal;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.dcache.auth.KAuthFile;
import org.dcache.auth.LoginReply;
import org.dcache.auth.LoginStrategy;
import org.dcache.auth.PasswordCredential;
import org.dcache.auth.Subjects;
import org.dcache.auth.UserAuthBase;
import org.dcache.auth.UserAuthRecord;
import org.dcache.auth.UserPwdRecord;
import org.dcache.auth.attributes.HomeDirectory;
import org.dcache.auth.attributes.LoginAttribute;
import org.dcache.auth.attributes.ReadOnly;
import org.dcache.auth.attributes.RootDirectory;
import org.globus.gsi.jaas.GlobusPrincipal;

public class KauthFileLoginStrategy
implements LoginStrategy {
    private final File _file;

    public KauthFileLoginStrategy(File file) {
        if (!file.canRead()) {
            throw new IllegalArgumentException("File not found: " + file);
        }
        this._file = file;
    }

    @Override
    public LoginReply login(Subject subject) throws CacheException {
        String user = Subjects.getLoginName((Subject)subject);
        Iterator<KerberosPrincipal> i$ = subject.getPrincipals(KerberosPrincipal.class).iterator();
        if (i$.hasNext()) {
            KerberosPrincipal principal = i$.next();
            return this.loginByUserNameAndId(user, principal.getName());
        }
        i$ = subject.getPrincipals(GlobusPrincipal.class).iterator();
        if (i$.hasNext()) {
            GlobusPrincipal principal = (GlobusPrincipal)i$.next();
            return this.loginByUserNameAndId(user, principal.getName());
        }
        return this.loginWithPassword(subject);
    }

    private KAuthFile loadKauthFile() throws CacheException {
        try {
            return new KAuthFile(this._file.getPath());
        }
        catch (IOException e) {
            throw new PermissionDeniedCacheException("Password file not found");
        }
    }

    private LoginReply loginByUserNameAndId(String user, String id) throws CacheException {
        KAuthFile kauth = this.loadKauthFile();
        if (user == null && (user = kauth.getIdMapping(id)) == null) {
            throw new PermissionDeniedCacheException("Access denied");
        }
        UserAuthRecord record = kauth.getUserRecord(user);
        if (record == null || !record.hasSecureIdentity(id)) {
            throw new PermissionDeniedCacheException("Access denied");
        }
        Subject subject = record.isAnonymous() ? Subjects.NOBODY : Subjects.getSubject((UserAuthRecord)record);
        return new LoginReply(subject, this.toLoginAttributes((UserAuthBase)record));
    }

    private LoginReply loginWithPassword(Subject subject) throws CacheException {
        KAuthFile kauth = this.loadKauthFile();
        Iterator<PasswordCredential> i$ = subject.getPrivateCredentials(PasswordCredential.class).iterator();
        if (i$.hasNext()) {
            PasswordCredential password = i$.next();
            UserPwdRecord record = kauth.getUserPwdRecord(password.getUsername());
            if (record == null || record.isDisabled()) {
                throw new PermissionDeniedCacheException("Access denied");
            }
            if (!record.isAnonymous() && !record.passwordIsValid(password.getPassword())) {
                throw new PermissionDeniedCacheException("Access denied");
            }
            subject = record.isAnonymous() ? Subjects.NOBODY : Subjects.getSubject((UserAuthBase)record, (boolean)true);
            return new LoginReply(subject, this.toLoginAttributes((UserAuthBase)record));
        }
        throw new IllegalArgumentException("Subject is not supported by KAuthFileLoginStrategy");
    }

    private Set<LoginAttribute> toLoginAttributes(UserAuthBase record) {
        HashSet<LoginAttribute> attributes = new HashSet<LoginAttribute>();
        attributes.add((LoginAttribute)new HomeDirectory(record.Home));
        attributes.add((LoginAttribute)new RootDirectory(record.Root));
        attributes.add((LoginAttribute)new ReadOnly(record.ReadOnly));
        return attributes;
    }

    @Override
    public Principal map(Principal principal) throws CacheException {
        return null;
    }

    @Override
    public Set<Principal> reverseMap(Principal principal) throws CacheException {
        return Collections.emptySet();
    }
}

