/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.auth;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.dcache.auth.AuthorizationRecord;
import org.dcache.auth.Group;
import org.dcache.auth.UserAuthRecord;

@Entity
@Table(name="authgrouplist")
public class GroupList
implements Serializable {
    private static final long serialVersionUID = 6742997958634986522L;
    private long id;
    private String attribute;
    private List<Group> groups;
    private AuthorizationRecord authRecord;

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="authsequence")
    @Column(name="id")
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @Basic
    public String getAttribute() {
        return this.attribute;
    }

    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    @OneToMany(mappedBy="groupList", fetch=FetchType.EAGER, targetEntity=Group.class, cascade={CascadeType.ALL})
    @OrderBy
    public List<Group> getGroups() {
        return this.groups;
    }

    public void setGroups(List<Group> groups) {
        this.groups = groups;
    }

    @ManyToOne(targetEntity=AuthorizationRecord.class, fetch=FetchType.EAGER)
    @JoinColumn(name="authrecord_id")
    public AuthorizationRecord getAuthRecord() {
        return this.authRecord;
    }

    public void setAuthRecord(AuthorizationRecord authRecord) {
        this.authRecord = authRecord;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toStringBuilder(sb);
        return sb.toString();
    }

    public void toStringBuilder(StringBuilder sb) {
        sb.append("GL:");
        sb.append(this.attribute).append(' ');
        if (this.groups != null) {
            sb.append(this.groups.size()).append(" groups : [");
            for (Group group : this.groups) {
                group.toStringBuilder(sb);
                sb.append(',');
            }
            sb.append(']');
        } else {
            sb.append(" [empty]");
        }
    }

    public String toShortString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.attribute).append(' ');
        if (this.groups != null) {
            sb.append('[');
            for (Group group : this.groups) {
                sb.append(group.getGid()).append(',');
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append(']');
        } else {
            sb.append("null");
        }
        return sb.toString();
    }

    public String hashCodeString() {
        return Integer.toHexString(this.hashCode());
    }

    @Transient
    public Group getPrimaryGroup() {
        if (this.groups != null && !this.groups.isEmpty()) {
            return this.groups.get(0);
        }
        return null;
    }

    public boolean equals(Object glist) {
        if (this == glist) {
            return true;
        }
        if (!(glist instanceof GroupList)) {
            return false;
        }
        GroupList gl = (GroupList)glist;
        if (this.attribute == null ? gl.getAttribute() != null : !this.attribute.equals(gl.getAttribute())) {
            return false;
        }
        return !(this.groups == null ? gl.getGroups() != null : !((Object)this.groups).equals(gl.getGroups()));
    }

    public int hashCode() {
        return this.toShortString().hashCode();
    }

    @Transient
    public UserAuthRecord getUserAuthRecord() {
        int i = 0;
        int glsize = this.groups.size();
        int[] GIDS = glsize > 0 ? new int[glsize] : null;
        for (Group group : this.groups) {
            GIDS[i++] = group.getGid();
        }
        return new UserAuthRecord(this.authRecord.getIdentity(), this.authRecord.getName(), this.attribute, this.authRecord.isReadOnly(), this.authRecord.getPriority(), this.authRecord.getUid(), GIDS, this.authRecord.getHome(), this.authRecord.getRoot(), "/", new HashSet());
    }
}

