/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.auth;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.security.auth.Subject;
import org.dcache.auth.FQAN;
import org.dcache.auth.FQANPrincipal;
import org.dcache.auth.GidPrincipal;
import org.dcache.auth.Group;
import org.dcache.auth.GroupList;
import org.dcache.auth.GroupNamePrincipal;
import org.dcache.auth.LoginReply;
import org.dcache.auth.UidPrincipal;
import org.dcache.auth.UserAuthRecord;
import org.dcache.auth.UserNamePrincipal;
import org.dcache.auth.attributes.HomeDirectory;
import org.dcache.auth.attributes.LoginAttribute;
import org.dcache.auth.attributes.ReadOnly;
import org.dcache.auth.attributes.RootDirectory;
import org.dcache.srm.SRMUser;
import org.globus.gsi.jaas.GlobusPrincipal;

@Entity
@Table(name="authrecord")
public class AuthorizationRecord
implements Serializable,
SRMUser {
    private static final long serialVersionUID = 7412538400840464074L;
    private static final String PRIMARY_ATTRIBUTE_PREFIX_THAT_RETURN_IDENTITY_AS_VO_GROUP = "/Role=";
    private long id;
    private String identity;
    private String name;
    private int uid;
    private List<GroupList> groupLists;
    private int priority = 0;
    private String home = "/";
    private String root = "/";
    private boolean readOnly = false;
    private int currentGIDindex = 0;
    private String authn = null;
    private String authz = null;

    public AuthorizationRecord() {
    }

    public AuthorizationRecord(Subject subject) {
        this(new LoginReply(subject, Collections.EMPTY_SET));
    }

    public AuthorizationRecord(LoginReply login) {
        boolean hasUid = false;
        LinkedList<GroupList> groupLists = new LinkedList<GroupList>();
        GroupList primaryGroupList = new GroupList();
        primaryGroupList.setAuthRecord(this);
        primaryGroupList.setGroups(new ArrayList<Group>());
        groupLists.add(primaryGroupList);
        this.setIdentity("");
        for (Principal principal : login.getSubject().getPrincipals()) {
            if (principal instanceof UidPrincipal) {
                if (hasUid) {
                    throw new IllegalArgumentException("Cannot convert Subject with more than one UID");
                }
                hasUid = true;
                this.setUid((int)((UidPrincipal)principal).getUid());
                continue;
            }
            if (principal instanceof FQANPrincipal) {
                FQANPrincipal fqanPrincipal = (FQANPrincipal)principal;
                if (fqanPrincipal.isPrimaryGroup() && primaryGroupList.getAttribute() == null) {
                    primaryGroupList.setAttribute(fqanPrincipal.getName());
                    continue;
                }
                GroupList groupList = new GroupList();
                groupList.setAuthRecord(this);
                groupList.setAttribute(fqanPrincipal.getName());
                groupList.setGroups(new ArrayList<Group>());
                groupLists.add(groupList);
                continue;
            }
            if (principal instanceof GidPrincipal) {
                GidPrincipal gidPrincipal = (GidPrincipal)principal;
                Group group = new Group();
                group.setGroupList(primaryGroupList);
                group.setGid((int)gidPrincipal.getGid());
                if (gidPrincipal.isPrimaryGroup()) {
                    primaryGroupList.getGroups().add(0, group);
                    continue;
                }
                primaryGroupList.getGroups().add(group);
                continue;
            }
            if (principal instanceof GlobusPrincipal) {
                this.setName(((GlobusPrincipal)principal).getName());
                continue;
            }
            if (principal instanceof UserNamePrincipal) {
                this.identity = ((UserNamePrincipal)principal).getName();
                continue;
            }
            if (!(principal instanceof GroupNamePrincipal)) continue;
            GroupNamePrincipal group = (GroupNamePrincipal)principal;
            if (this.identity == null || !group.isPrimaryGroup()) continue;
            this.identity = ((GroupNamePrincipal)principal).getName();
        }
        if (!hasUid) {
            throw new IllegalArgumentException("Cannot convert Subject without UID");
        }
        this.setGroupLists(groupLists);
        for (LoginAttribute attribute : login.getLoginAttributes()) {
            if (attribute instanceof RootDirectory) {
                this.setRoot(((RootDirectory)attribute).getRoot());
                continue;
            }
            if (attribute instanceof HomeDirectory) {
                this.setHome(((HomeDirectory)attribute).getHome());
                continue;
            }
            if (!(attribute instanceof ReadOnly)) continue;
            this.setReadOnly(((ReadOnly)attribute).isReadOnly());
        }
        this.setId();
    }

    public Subject toSubject() {
        Subject subject = new Subject();
        Set<Principal> principals = subject.getPrincipals();
        principals.add((Principal)new UidPrincipal((long)this.getUid()));
        String identity = this.getIdentity();
        if (identity != null && !identity.isEmpty()) {
            principals.add((Principal)new UserNamePrincipal(identity));
        }
        boolean primary = true;
        for (GroupList list : this.getGroupLists()) {
            String fqan = list.getAttribute();
            if (fqan != null && !fqan.isEmpty()) {
                principals.add((Principal)new FQANPrincipal(fqan, primary));
            }
            for (Group group : list.getGroups()) {
                principals.add((Principal)new GidPrincipal((long)group.getGid(), primary));
                primary = false;
            }
            primary = false;
        }
        String dn = this.getName();
        if (dn != null && !dn.isEmpty()) {
            principals.add((Principal)new GlobusPrincipal(dn));
        }
        return subject;
    }

    @Id
    @Column(name="id")
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setId() {
        if (this.id != 0L) {
            return;
        }
        this.id = this.getId(this);
    }

    @Basic
    @Column(name="identity")
    public String getIdentity() {
        return this.identity;
    }

    public void setIdentity(String identity) {
        this.identity = identity;
    }

    @Basic
    @Column(name="uid")
    public int getUid() {
        return this.uid;
    }

    public void setUid(int uid) {
        this.uid = uid;
    }

    @OneToMany(mappedBy="authRecord", fetch=FetchType.EAGER, targetEntity=GroupList.class, cascade={CascadeType.ALL})
    @OrderBy
    public List<GroupList> getGroupLists() {
        return this.groupLists;
    }

    public void setGroupLists(List<GroupList> groupLists) {
        this.groupLists = groupLists;
    }

    @Basic
    @Column(name="priority")
    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Basic
    @Column(name="home")
    public String getHome() {
        return this.home;
    }

    public void setHome(String Home) {
        Preconditions.checkNotNull((Object)Home);
        this.home = Home;
    }

    @Basic
    @Column(name="root")
    public String getRoot() {
        return this.root;
    }

    public void setRoot(String Root) {
        Preconditions.checkNotNull((Object)Root);
        this.root = Root;
    }

    @Basic
    @Column(name="read_only")
    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean ReadOnly2) {
        this.readOnly = ReadOnly2;
    }

    @Transient
    public String getAuthn() {
        if (this.authn == null) {
            this.initHashStrings();
        }
        return this.authn;
    }

    @Transient
    public String getAuthz() {
        if (this.authz == null) {
            this.initHashStrings();
        }
        return this.authz;
    }

    @Transient
    public int getCurrentGIDindex() {
        return this.currentGIDindex;
    }

    public void setCurrentGIDindex(int currentGIDindex) {
        this.currentGIDindex = currentGIDindex;
    }

    public void incrementGIDindex() {
        ++this.currentGIDindex;
    }

    @Basic
    @Column(name="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("AR:");
        sb.append(this.getId());
        sb.append(' ').append(this.identity);
        sb.append(' ').append(this.name);
        sb.append(' ').append(this.uid);
        if (this.readOnly) {
            sb.append(" read-only ");
        } else {
            sb.append(" read-write ");
        }
        sb.append(this.priority).append(' ');
        sb.append(this.home).append(' ');
        sb.append(this.root).append(" < ");
        if (this.groupLists != null) {
            sb.append(this.groupLists.size()).append(" groupLists : ");
            for (GroupList groupList : this.groupLists) {
                sb.append("  ").append(groupList).append(';');
            }
        } else {
            sb.append("empty");
        }
        sb.append(" >");
        return sb.toString();
    }

    public String hashCodeString() {
        return Integer.toHexString(this.hashCode());
    }

    @Transient
    public String getVoRole() {
        FQAN fqan;
        String primaryAttribute = this.getPrimaryAttribute();
        if (FQAN.isValid((String)primaryAttribute) && (fqan = new FQAN(primaryAttribute)).hasRole()) {
            return fqan.getRole();
        }
        return null;
    }

    @Transient
    public String getVoGroup() {
        String primaryAttribute = this.getPrimaryAttribute();
        if (primaryAttribute != null && !primaryAttribute.isEmpty()) {
            if (FQAN.isValid((String)primaryAttribute)) {
                return new FQAN(primaryAttribute).getGroup();
            }
            if (!primaryAttribute.startsWith(PRIMARY_ATTRIBUTE_PREFIX_THAT_RETURN_IDENTITY_AS_VO_GROUP)) {
                return primaryAttribute;
            }
        }
        return this.identity;
    }

    @Transient
    protected String getPrimaryAttribute() {
        GroupList primaryGroupList = this.getPrimaryGroupList();
        if (primaryGroupList != null) {
            return primaryGroupList.getAttribute();
        }
        return null;
    }

    @Transient
    protected GroupList getPrimaryGroupList() {
        if (this.groupLists != null && !this.groupLists.isEmpty()) {
            return this.groupLists.get(0);
        }
        return null;
    }

    @Transient
    public int getGid() {
        Group primaryGroup;
        GroupList primaryGroupList = this.getPrimaryGroupList();
        if (primaryGroupList != null && (primaryGroup = primaryGroupList.getPrimaryGroup()) != null) {
            return primaryGroup.getGid();
        }
        return -1;
    }

    @Transient
    public long getId(AuthorizationRecord authrec) {
        long id = authrec.getId();
        if (id != 0L) {
            return id;
        }
        int authn_hash = this.getAuthn().hashCode();
        int authz_hash = this.getAuthz().hashCode();
        id = (long)authn_hash << 32 | (long)authz_hash & 0xFFFFFFFFL;
        return id;
    }

    private void initHashStrings() {
        if (this.authn != null && this.authz != null) {
            return;
        }
        StringBuilder authn = new StringBuilder();
        StringBuilder authz = new StringBuilder();
        authn.append(this.name);
        authz.append(this.uid);
        if (this.groupLists != null) {
            authn.append(',');
            authz.append(' ');
            for (GroupList groupList : this.groupLists) {
                if (groupList != null) {
                    authn.append(groupList.getAttribute()).append('|');
                    authz.append(groupList.toShortString()).append('|');
                    continue;
                }
                authn.append("null|");
                authz.append("null|");
            }
            authn.deleteCharAt(authn.length() - 1);
            authz.deleteCharAt(authz.length() - 1);
        }
        if (this.readOnly) {
            authz.append(" read-only");
        } else {
            authz.append(" read-write");
        }
        authz.append(' ').append(this.priority);
        authz.append(' ').append(this.home);
        authz.append(' ').append(this.root);
        this.authn = authn.toString();
        this.authz = authz.toString();
    }

    public boolean equals(Object rec) {
        if (this == rec) {
            return true;
        }
        if (!(rec instanceof AuthorizationRecord)) {
            return false;
        }
        AuthorizationRecord r = (AuthorizationRecord)rec;
        return Objects.equal((Object)this.identity, (Object)r.identity) && Objects.equal((Object)this.name, (Object)r.name) && this.uid == r.getUid() && this.readOnly == r.isReadOnly() && Objects.equal(this.groupLists, r.groupLists) && this.priority == r.getPriority() && Objects.equal((Object)this.home, (Object)r.home) && Objects.equal((Object)this.root, (Object)r.root);
    }

    public int hashCode() {
        this.initHashStrings();
        return this.getAuthn().hashCode() ^ this.getAuthz().hashCode();
    }

    @Transient
    public int[] getGids() {
        ArrayList<Integer> gids = new ArrayList<Integer>();
        if (this.groupLists != null) {
            for (GroupList groupList : this.groupLists) {
                List<Group> groups = groupList.getGroups();
                if (groups == null) continue;
                for (Group group : groups) {
                    gids.add(group.getGid());
                }
            }
        }
        if (gids.isEmpty()) {
            return new int[]{-1};
        }
        int[] gidIntArray = new int[gids.size()];
        for (int i = 0; i < gidIntArray.length; ++i) {
            gidIntArray[i] = (Integer)gids.get(i);
        }
        return gidIntArray;
    }

    @Transient
    public UserAuthRecord getUserAuthRecord() {
        return new UserAuthRecord(this.getIdentity(), this.getName(), this.getPrimaryAttribute(), this.isReadOnly(), this.getPriority(), this.getUid(), this.getGids(), this.getHome(), this.getRoot(), "/", new HashSet());
    }
}

