/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.auth;

import diskCacheV111.util.CacheException;
import java.security.Principal;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.Subject;
import org.dcache.auth.GidPrincipal;
import org.dcache.auth.LoginReply;
import org.dcache.auth.LoginStrategy;
import org.dcache.auth.Subjects;
import org.dcache.auth.UidPrincipal;
import org.dcache.auth.attributes.LoginAttribute;
import org.dcache.auth.attributes.RootDirectory;
import org.springframework.beans.factory.annotation.Required;

public class AnonymousLoginStrategy
implements LoginStrategy {
    public static final String USER_ROOT = "root";
    public static final String USER_NOBODY = "nobody";
    public static final Pattern USER_PATTERN = Pattern.compile("(\\d+):((\\d+)(,(\\d+))*)");
    private Subject _subject;
    private String _rootPath;

    @Override
    public LoginReply login(Subject subject) throws CacheException {
        RootDirectory rootPath = new RootDirectory(this._rootPath);
        HashSet<LoginAttribute> attributes = new HashSet<LoginAttribute>();
        attributes.add((LoginAttribute)rootPath);
        LoginReply reply = new LoginReply(this._subject, attributes);
        return reply;
    }

    @Override
    public Principal map(Principal principal) throws CacheException {
        return null;
    }

    @Override
    public Set<Principal> reverseMap(Principal principal) throws CacheException {
        return null;
    }

    private Subject parseUidGidList(String user) {
        Matcher matcher = USER_PATTERN.matcher(user);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid user string");
        }
        Subject subject = new Subject();
        int uid = Integer.parseInt(matcher.group(1));
        Set<Principal> principals = subject.getPrincipals();
        principals.add((Principal)new UidPrincipal((long)uid));
        boolean primary = true;
        for (String group : matcher.group(2).split(",")) {
            int gid = Integer.parseInt(group);
            principals.add((Principal)new GidPrincipal((long)gid, primary));
            primary = false;
        }
        subject.setReadOnly();
        return subject;
    }

    @Required
    public void setUser(String user) {
        this._subject = user.equals(USER_ROOT) ? Subjects.ROOT : (user.equals(USER_NOBODY) ? Subjects.NOBODY : this.parseUidGidList(user));
    }

    @Required
    public void setRootPath(String rootPath) {
        this._rootPath = rootPath;
    }
}

