/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.admin.webadmin.jettycell;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dcache.cells.AbstractCell;
import org.dcache.cells.Option;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.server.ssl.SslSelectChannelConnector;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.webapp.WebAppContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyCell
extends AbstractCell {
    public static final String IPV4_INETADDR_ANY = "0.0.0.0";
    public static final String JETTYCELL_NAMING_CONTEXT = "jettycell";
    public static final int MAX_IDLE_TIME = 30000;
    public static final int MAX_THREADS = 100;
    public static final String WEBAPP_CONTEXT = "/webadmin";
    private static final String WEBADMIN_TEMP_UNPACK_DIR = "/webadmin";
    private static final String WEBDEFAULT_XML = "/webdefault.xml";
    private static final Logger _log = LoggerFactory.getLogger(JettyCell.class);
    @Option(name="webappsPath", description="path to the .war files with the webapps", required=true)
    private String _webappsPath;
    @Option(name="authenticated", description="webapp runs in authenticated mode", required=true)
    private boolean _authenticatedMode;
    @Option(name="httpPort", description="Port where Jetty is connectable via http", required=true)
    private int _httpPort;
    @Option(name="httpsPort", description="Port where Jetty is connectable via https", required=false)
    private int _httpsPort;
    @Option(name="keystore", description="The keystore for SSL", required=false)
    private String _keystore;
    @Option(name="keystoreType", description="The keystoreType for SSL", required=false)
    private String _keystoreType;
    @Option(name="keystorePassword", description="The keystore password", log=false, required=false)
    private String _keystorePassword;
    @Option(name="truststore", description="The truststore for SSL", required=false)
    private String _truststore;
    @Option(name="truststorePassword", description="The truststore password", log=false, required=false)
    private String _trustPassword;
    @Option(name="admin-GID", description="admin GID for webadmininterface", required=false)
    private int _adminGid;
    @Option(name="kpwd-file", description="path to the kpwd-file", required=false)
    private String _kpwdFile;
    @Option(name="dCacheInstanceName", description="The dCache-Instance Name", required=false)
    private String _dcacheName;
    @Option(name="loginBrokerName", description="LoginBrokers Name", required=true)
    private String _loginBrokerName;
    @Option(name="pnfsManagerName", description="Name of pnfsManager cell", required=true)
    private String _pnfsManagerName;
    @Option(name="poolManagerName", description="Name of poolManager cell", required=true)
    private String _poolManagerName;
    @Option(name="gPlazmaName", description="Name of gPlazma cell", required=true)
    private String _gPlazmaName;
    @Option(name="collectorTimeout", description="timeout for the collectors", required=true)
    private long _collectorTimeout;
    @Option(name="transfersCollectorUpdate", description="Update interval of transferscollector", required=true)
    private long _transfersCollectorUpdate;
    @Option(name="tempUnpackDir", description="directoy in which war-files get unpacked", required=true)
    private String _tempUnpackDir;
    private final URL _resourceURL = JettyCell.class.getResource("/org/dcache/admin/webadmin/jettycell/resources");
    private Server _server;

    public JettyCell(String cellName, String args) throws InterruptedException, ExecutionException {
        super(cellName, args);
        _log.debug("constructor entered");
        this.doInit();
        _log.debug("Constructor successfully called");
    }

    @Override
    protected void init() throws Exception {
        super.init();
        _log.debug("initialising");
        this.createJetty();
    }

    private void createJetty() {
        this._server = new Server(this._httpPort);
        this.createAndSetThreadPool();
        if (this._authenticatedMode) {
            this._server.setConnectors(new Connector[]{this.createSimpleConnector(), this.createSslConnector()});
        } else {
            this._server.setConnectors(new Connector[]{this.createSimpleConnector()});
        }
        this.createAndSetHandlers();
        try {
            InitialContext namingContext = new InitialContext();
            namingContext.bind(JETTYCELL_NAMING_CONTEXT, (Object)this);
            _log.debug("starting server");
            this._server.start();
        }
        catch (NamingException ex) {
            _log.error("Namingcontext couldn't initialise (jndi-lib in classpath?) " + ex.getMessage());
        }
        catch (Exception e) {
            _log.error("Jettyserver threw Exception: " + e.getMessage());
            this._server.destroy();
        }
    }

    private void createAndSetThreadPool() {
        QueuedThreadPool threadPool = new QueuedThreadPool();
        threadPool.setMaxThreads(100);
        this._server.setThreadPool((ThreadPool)threadPool);
    }

    private Connector createSimpleConnector() {
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setPort(this._httpPort);
        connector.setMaxIdleTime(30000);
        return connector;
    }

    private Connector createSslConnector() {
        SslSelectChannelConnector connector = new SslSelectChannelConnector();
        connector.setPort(this._httpsPort);
        connector.setHost(IPV4_INETADDR_ANY);
        connector.setKeystore(this._keystore);
        connector.setKeystoreType(this._keystoreType);
        connector.setPassword(this._keystorePassword);
        connector.setTruststore(this._truststore);
        connector.setTrustPassword(this._trustPassword);
        connector.setWantClientAuth(true);
        connector.setNeedClientAuth(false);
        return connector;
    }

    private void createAndSetHandlers() {
        RequestLogHandler requestLogHandler = new RequestLogHandler();
        HandlerCollection handlers = new HandlerCollection();
        handlers.setHandlers(new Handler[]{this.createWebappContext(), new LegacyForwardHandler(), new DefaultHandler(), requestLogHandler});
        this._server.setHandler((Handler)handlers);
    }

    private WebAppContext createWebappContext() {
        WebAppContext webappContext = new WebAppContext();
        _log.debug(this._resourceURL.toExternalForm());
        webappContext.setDefaultsDescriptor(this._resourceURL.toExternalForm() + WEBDEFAULT_XML);
        webappContext.setContextPath("/webadmin");
        webappContext.setWar(this._webappsPath + "/webadmin" + ".war");
        webappContext.setExtractWAR(true);
        webappContext.setTempDirectory(new File(this._tempUnpackDir + "/webadmin"));
        return webappContext;
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        try {
            this._server.stop();
        }
        catch (Exception ex) {
            _log.debug("Exception during server stop: {}", (Throwable)ex);
            this._server.destroy();
        }
    }

    public int getAdminGid() {
        return this._adminGid;
    }

    public String getKpwdFile() {
        return this._kpwdFile;
    }

    public String getDcacheName() {
        return this._dcacheName;
    }

    public int getHttpPort() {
        return this._httpPort;
    }

    public int getHttpsPort() {
        return this._httpsPort;
    }

    public boolean isAuthenticatedMode() {
        return this._authenticatedMode;
    }

    public long getCollectorTimeout() {
        return this._collectorTimeout;
    }

    public String getLoginBrokerName() {
        return this._loginBrokerName;
    }

    public String getPnfsManagerName() {
        return this._pnfsManagerName;
    }

    public String getPoolManagerName() {
        return this._poolManagerName;
    }

    public String getGPlazmaName() {
        return this._gPlazmaName;
    }

    public long getTransfersCollectorUpdate() {
        return this._transfersCollectorUpdate;
    }

    public String getTempUnpackDir() {
        return this._tempUnpackDir;
    }

    private class LegacyForwardHandler
    extends AbstractHandler {
        private final String INFO_CONTEXT = "/info";
        private final String CELLINFO_CONTEXT = "/cellInfo";
        private final String QUEUEINFO_CONTEXT = "/queueInfo";
        private final String USAGEINFO_CONTEXT = "/usageInfo";
        private final String POOLGROUPS_CONTEXT = "/pools";
        private final String POOLINFO_CONTEXT = "/poolinfo";
        private final String RESTORE_CONTEXT = "/poolinfo/restoreHandler/*";
        private final String RESTORE_LAZY_CONTEXT = "/poolinfo/restoreHandler/lazy";
        private final String WEBADMIN_INFO_CONTEXT = "/webadmin/info?statepath=";
        private final String WEBADMIN_CELLINFO_CONTEXT = "/webadmin/cellinfo";
        private final String WEBADMIN_QUEUEINFO_CONTEXT = "/webadmin/queueinfo";
        private final String WEBADMIN_USAGEINFO_CONTEXT = "/webadmin/usageinfo";
        private final String WEBADMIN_POOLGROUPS_CONTEXT = "/webadmin/poolgroups";
        private final String WEBADMIN_POOLINFO_CONTEXT = "/webadmin/poolinfo";
        private final String WEBADMIN_RESTORE_CONTEXT = "/webadmin/tapetransfers";
        private final int CONTEXT_INDEX = 1;
        private Map<String, String> legacyContextToNewContext = new HashMap<String, String>();

        private LegacyForwardHandler() {
        }

        protected void doStart() throws Exception {
            super.doStart();
            this.initContextMapping();
        }

        private void initContextMapping() {
            _log.debug("init of urlmap");
            this.legacyContextToNewContext.put("/info", "/webadmin/info?statepath=");
            this.legacyContextToNewContext.put("/cellInfo", "/webadmin/cellinfo");
            this.legacyContextToNewContext.put("/queueInfo", "/webadmin/queueinfo");
            this.legacyContextToNewContext.put("/usageInfo", "/webadmin/usageinfo");
            this.legacyContextToNewContext.put("/pools", "/webadmin/poolgroups");
            this.legacyContextToNewContext.put("/poolinfo", "/webadmin/poolinfo");
            this.legacyContextToNewContext.put("/poolinfo/restoreHandler/*", "/webadmin/tapetransfers");
            this.legacyContextToNewContext.put("/poolinfo/restoreHandler/lazy", "/webadmin/tapetransfers");
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            if (target.equals("/")) {
                response.sendRedirect("/webadmin");
                return;
            }
            String[] contexts = target.split("/");
            if (this.isContextLegacyOne(contexts)) {
                _log.debug("target: {}", (Object)target);
                String legacyContext = "/" + contexts[1];
                String webadminContext = this.legacyContextToNewContext.get(legacyContext);
                StringBuffer targetUrl = new StringBuffer(target);
                int i = targetUrl.indexOf(legacyContext);
                String newUrl = targetUrl.replace(i, i + legacyContext.length(), webadminContext).toString();
                _log.debug("redirected to: {}", (Object)newUrl);
                response.sendRedirect(newUrl);
            }
        }

        private boolean isContextLegacyOne(String[] contexts) {
            if (contexts.length > 1) {
                return this.legacyContextToNewContext.containsKey("/" + contexts[1]);
            }
            return false;
        }
    }
}

