/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.admin.webadmin.datacollector.datatypes;

import com.google.common.base.Preconditions;
import diskCacheV111.vehicles.IoDoorEntry;
import diskCacheV111.vehicles.IoDoorInfo;
import diskCacheV111.vehicles.IoJobInfo;

public class MoverInfo
implements Comparable<MoverInfo> {
    private final IoDoorInfo _ioDoorInfo;
    private final IoDoorEntry _ioDoorEntry;
    private IoJobInfo _ioJobInfo = null;

    public MoverInfo(IoDoorInfo info, IoDoorEntry entry) {
        Preconditions.checkNotNull((Object)info);
        Preconditions.checkNotNull((Object)entry);
        this._ioDoorInfo = info;
        this._ioDoorEntry = entry;
    }

    public void setIoJobInfo(IoJobInfo ioJobInfo) {
        this._ioJobInfo = ioJobInfo;
    }

    public IoJobInfo getIoJobInfo() {
        return this._ioJobInfo;
    }

    public IoDoorEntry getIoDoorEntry() {
        return this._ioDoorEntry;
    }

    public IoDoorInfo getIoDoorInfo() {
        return this._ioDoorInfo;
    }

    public boolean hasJobInfo() {
        return this._ioJobInfo != null;
    }

    @Override
    public int compareTo(MoverInfo other) {
        int tmp = this._ioDoorInfo.getDomainName().compareTo(other._ioDoorInfo.getDomainName());
        if (tmp != 0) {
            return tmp;
        }
        tmp = this._ioDoorInfo.getCellName().compareTo(other._ioDoorInfo.getCellName());
        if (tmp != 0) {
            return tmp;
        }
        return Long.valueOf(this._ioDoorEntry.getSerialId()).compareTo(other._ioDoorEntry.getSerialId());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MoverInfo)) {
            return false;
        }
        MoverInfo other = (MoverInfo)obj;
        return this._ioDoorInfo.getDomainName().equals(other._ioDoorInfo.getDomainName()) && this._ioDoorInfo.getCellName().equals(other._ioDoorInfo.getCellName()) && this._ioDoorEntry.getSerialId() == other._ioDoorEntry.getSerialId();
    }

    public int hashCode() {
        return (int)this._ioDoorEntry.getSerialId() ^ this._ioDoorInfo.getCellName().hashCode() ^ this._ioDoorInfo.getDomainName().hashCode();
    }
}

