/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.vehicles.transferManager;

import diskCacheV111.vehicles.Message;

public abstract class TransferManagerMessage
extends Message {
    public static final int TOO_MANY_TRANSFERS = 1;
    public static final int FILE_NOT_FOUND = 2;
    public static final int NO_ACCESS = 2;
    public static final int POOL_FAILURE = 3;
    static final long serialVersionUID = -5532348977012216312L;
    private String spaceReservationId;
    private Long size;
    private boolean store;
    private String pnfsPath;
    private String remoteUrl;
    private boolean spaceReservationStrict;
    private Long credentialId;

    public TransferManagerMessage(String pnfsPath, String remoteUrl, boolean store, Long remoteCredentialId) {
        this(pnfsPath, remoteUrl, store, remoteCredentialId, null, false, null);
    }

    public TransferManagerMessage(String pnfsPath, String remoteUrl, boolean store, Long remoteCredentialId, String spaceReservationId, boolean spaceReservationStrict, Long size) {
        this.pnfsPath = pnfsPath;
        this.remoteUrl = remoteUrl;
        this.store = store;
        this.spaceReservationId = spaceReservationId;
        this.spaceReservationStrict = spaceReservationStrict;
        this.size = size;
        this.credentialId = remoteCredentialId;
    }

    public TransferManagerMessage(TransferManagerMessage original) {
        this.setId(original.getId());
        this.pnfsPath = original.pnfsPath;
        this.remoteUrl = original.remoteUrl;
        this.store = original.store;
        this.spaceReservationId = original.spaceReservationId;
        this.size = original.size;
        this.credentialId = original.credentialId;
    }

    public TransferManagerMessage() {
    }

    public boolean isStore() {
        return this.store;
    }

    public String getPnfsPath() {
        return this.pnfsPath;
    }

    public String getRemoteURL() {
        return this.remoteUrl;
    }

    public String getSpaceReservationId() {
        return this.spaceReservationId;
    }

    public void setSpaceReservationId(String spaceReservationId) {
        this.spaceReservationId = spaceReservationId;
    }

    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public boolean isSpaceReservationStrict() {
        return this.spaceReservationStrict;
    }

    public void setSpaceReservationStrict(boolean spaceReservationStrict) {
        this.spaceReservationStrict = spaceReservationStrict;
    }

    public Long getCredentialId() {
        return this.credentialId;
    }

    public void setCredentialId(Long credentialId) {
        this.credentialId = credentialId;
    }
}

