/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.vehicles.transferManager;

import com.google.common.base.Preconditions;
import diskCacheV111.vehicles.IpProtocolInfo;
import java.io.Serializable;
import java.net.InetSocketAddress;
import org.ietf.jgss.GSSCredential;

public class RemoteGsiftpTransferProtocolInfo
implements IpProtocolInfo {
    private static final long serialVersionUID = 7046410066693122355L;
    private final String name;
    private final int minor;
    private final int major;
    private final String[] hosts;
    private final String gsiftpUrl;
    private final int port;
    private long transferTime = 0L;
    private long bytesTransferred = 0L;
    private final String gsiftpTranferManagerName;
    private final String gsiftpTranferManagerDomain;
    private boolean emode = true;
    private int streams_num = 5;
    private int bufferSize = 0;
    private int tcpBufferSize = 0;
    @Deprecated
    private final Long requestCredentialId;
    private final String user;
    private final GSSCredential credential;

    public RemoteGsiftpTransferProtocolInfo(String protocol, int major, int minor, String[] hosts, int port, String gsiftpUrl, String gsiftpTranferManagerName, String gsiftpTranferManagerDomain, int bufferSize, int tcpBufferSize, @Deprecated Long requestCredentialId, GSSCredential credential) {
        this(protocol, major, minor, hosts, port, gsiftpUrl, gsiftpTranferManagerName, gsiftpTranferManagerDomain, bufferSize, tcpBufferSize, requestCredentialId, credential, null);
    }

    public RemoteGsiftpTransferProtocolInfo(String protocol, int major, int minor, String[] hosts, int port, String gsiftpUrl, String gsiftpTranferManagerName, String gsiftpTranferManagerDomain, int bufferSize, int tcpBufferSize, @Deprecated Long requestCredentialId, GSSCredential credential, String user) {
        Preconditions.checkArgument((boolean)(credential instanceof Serializable), (Object)"Credential must be Serializable");
        this.name = protocol;
        this.minor = minor;
        this.major = major;
        this.hosts = hosts;
        this.port = port;
        this.gsiftpUrl = gsiftpUrl;
        this.gsiftpTranferManagerName = gsiftpTranferManagerName;
        this.gsiftpTranferManagerDomain = gsiftpTranferManagerDomain;
        this.bufferSize = bufferSize;
        this.tcpBufferSize = tcpBufferSize;
        this.requestCredentialId = requestCredentialId;
        this.credential = credential;
        this.user = user;
    }

    public String getGsiftpUrl() {
        return this.gsiftpUrl;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    @Override
    public String getProtocol() {
        return this.name;
    }

    @Override
    public int getMinorVersion() {
        return this.minor;
    }

    @Override
    public int getMajorVersion() {
        return this.major;
    }

    @Override
    public String getVersionString() {
        return this.name + "-" + this.major + "." + this.minor;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String[] getHosts() {
        return this.hosts;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getVersionString());
        for (int i = 0; i < this.hosts.length; ++i) {
            sb.append(',').append(this.hosts[i]);
        }
        sb.append(':').append(this.port);
        return sb.toString();
    }

    public boolean isFileCheckRequired() {
        return true;
    }

    public String getGsiftpTranferManagerName() {
        return this.gsiftpTranferManagerName;
    }

    public String getGsiftpTranferManagerDomain() {
        return this.gsiftpTranferManagerDomain;
    }

    public boolean isEmode() {
        return this.emode;
    }

    public void setEmode(boolean emode) {
        this.emode = emode;
    }

    public int getNumberOfStreams() {
        return this.streams_num;
    }

    public void setNumberOfStreams(int streams_num) {
        this.streams_num = streams_num;
    }

    public int getTcpBufferSize() {
        return this.tcpBufferSize;
    }

    public void setTcpBufferSize(int tcpBufferSize) {
        this.tcpBufferSize = tcpBufferSize;
    }

    @Deprecated
    public Long getRequestCredentialId() {
        return this.requestCredentialId;
    }

    public String getUser() {
        return this.user;
    }

    @Override
    public InetSocketAddress getSocketAddress() {
        return null;
    }

    public GSSCredential getCredential() {
        return this.credential;
    }
}

