/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.vehicles;

import com.google.common.base.Preconditions;
import diskCacheV111.poolManager.RequestContainerV5;
import diskCacheV111.vehicles.PoolMgrSelectPoolMsg;
import diskCacheV111.vehicles.ProtocolInfo;
import java.io.Serializable;
import java.util.EnumSet;
import org.dcache.namespace.FileAttribute;
import org.dcache.vehicles.FileAttributes;

public class PoolMgrSelectReadPoolMsg
extends PoolMgrSelectPoolMsg {
    private static final long serialVersionUID = -2126253028981131441L;
    private Context _context;

    public PoolMgrSelectReadPoolMsg(FileAttributes fileAttributes, ProtocolInfo protocolInfo, long fileSize, Context context) {
        this(fileAttributes, protocolInfo, fileSize, context, RequestContainerV5.allStates);
        Preconditions.checkArgument((boolean)fileAttributes.getDefinedAttributes().containsAll(PoolMgrSelectReadPoolMsg.getRequiredAttributes()), (Object)"Required attributes are missing");
    }

    public PoolMgrSelectReadPoolMsg(FileAttributes fileAttributes, ProtocolInfo protocolInfo, long fileSize, Context context, EnumSet<RequestContainerV5.RequestState> allowedStates) {
        super(fileAttributes, protocolInfo, fileSize, allowedStates);
        this._context = context == null ? new Context() : context;
    }

    public static EnumSet<FileAttribute> getRequiredAttributes() {
        return EnumSet.of(FileAttribute.PNFSID, FileAttribute.STORAGEINFO, FileAttribute.LOCATIONS);
    }

    public Context getContext() {
        return this._context;
    }

    public void setContext(Context context) {
        this._context = context;
    }

    public void setContext(int retryCounter, String previousStageHost) {
        this.setContext(new Context(retryCounter, previousStageHost));
    }

    public static class Context
    implements Serializable {
        private final int _retryCounter;
        private final String _previousStageHost;

        public Context() {
            this._retryCounter = 0;
            this._previousStageHost = null;
        }

        public Context(int retryCounter, String previousStageHost) {
            this._retryCounter = retryCounter;
            this._previousStageHost = previousStageHost;
        }

        public int getRetryCounter() {
            return this._retryCounter;
        }

        public String getPreviousStageHost() {
            return this._previousStageHost;
        }
    }
}

