/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.vehicles;

import com.google.common.base.Preconditions;
import diskCacheV111.util.PnfsId;
import diskCacheV111.vehicles.PoolManagerMessage;
import diskCacheV111.vehicles.StorageInfo;
import java.util.EnumSet;
import org.dcache.namespace.FileAttribute;
import org.dcache.vehicles.FileAttributes;

public class PoolMgrGetPoolMsg
extends PoolManagerMessage {
    private static final long serialVersionUID = 8907604668091102254L;
    private final FileAttributes _fileAttributes;
    private String _poolName;

    public PoolMgrGetPoolMsg(FileAttributes fileAttributes) {
        Preconditions.checkArgument((boolean)fileAttributes.getDefinedAttributes().containsAll(PoolMgrGetPoolMsg.getRequiredAttributes()), (Object)"Required attributes are missing");
        this._fileAttributes = fileAttributes;
        this.setReplyRequired(true);
    }

    public FileAttributes getFileAttributes() {
        return this._fileAttributes;
    }

    public StorageInfo getStorageInfo() {
        return this._fileAttributes.getStorageInfo();
    }

    public PnfsId getPnfsId() {
        return this._fileAttributes.getPnfsId();
    }

    public String getPoolName() {
        return this._poolName;
    }

    public void setPoolName(String poolName) {
        this._poolName = poolName;
    }

    @Override
    public String toString() {
        if (this.getReturnCode() == 0) {
            return "PnfsId=" + this.getPnfsId() + ";StorageInfo=" + this.getStorageInfo() + ";PoolName=" + (this._poolName == null ? "<unknown>" : this._poolName);
        }
        return super.toString();
    }

    public static EnumSet<FileAttribute> getRequiredAttributes() {
        return EnumSet.of(FileAttribute.PNFSID, FileAttribute.STORAGEINFO);
    }
}

