/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.vehicles;

import dmg.util.Formats;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class PoolClassAttraction
implements Serializable {
    private String _organization;
    private String _storageClass;
    private boolean _isTemplate = false;
    private HashMap _map = null;
    private int _writePreference = -1;
    private int _readPreference = -1;
    private String _poolName;
    private String _id = null;
    public static final PoolClassComparator comparatorForWrite = new PoolClassComparator(true);
    public static final PoolClassComparator comparatorForRead = new PoolClassComparator(false);
    private static final long serialVersionUID = 5471965365309761831L;

    public PoolClassAttraction(String poolName, String organization, String storageClass) {
        this._poolName = poolName;
        this._organization = organization.toLowerCase();
        this._storageClass = storageClass;
        if (this._storageClass.startsWith("*")) {
            this.createTemplate();
        }
        this.makeId();
    }

    public boolean isTemplate() {
        return this._isTemplate;
    }

    public Iterator getSelection() {
        if (!this._isTemplate || this._map == null) {
            return new ArrayList().iterator();
        }
        return this._map.entrySet().iterator();
    }

    private void createTemplate() {
        if (this._storageClass.length() == 1) {
            this._isTemplate = true;
            return;
        }
        this._isTemplate = true;
        StringTokenizer st = new StringTokenizer(this._storageClass.substring(1), "*");
        this._map = new HashMap();
        while (st.hasMoreTokens()) {
            String selection = st.nextToken();
            StringTokenizer st2 = new StringTokenizer(selection, "=");
            try {
                this._map.put(st2.nextToken(), st2.nextToken());
            }
            catch (NoSuchElementException nsee) {}
        }
        if (this._map.size() == 0) {
            this._map = null;
        }
    }

    public String getOrganization() {
        return this._organization;
    }

    public String getStorageClass() {
        return this._storageClass;
    }

    public int getWritePreference() {
        return this._writePreference;
    }

    public int getReadPreference() {
        return this._readPreference;
    }

    public String getPool() {
        return this._poolName;
    }

    public static Comparator getComparator(boolean forWrite) {
        return forWrite ? comparatorForWrite : comparatorForRead;
    }

    public void setPreferences(int readPreference, int writePreference) {
        this._writePreference = writePreference;
        this._readPreference = readPreference;
    }

    private void makeId() {
        this._id = this._poolName + ":" + this._storageClass + "@" + this._organization;
    }

    public void setWritePreference(int writePreference) {
        this._writePreference = writePreference;
    }

    public void setReadPreference(int readPreference) {
        this._readPreference = readPreference;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PoolClassAttraction)) {
            return false;
        }
        PoolClassAttraction o = (PoolClassAttraction)obj;
        return o._id.equals(this._id);
    }

    public int hashCode() {
        return this._id.hashCode();
    }

    public String toString() {
        if (!this._isTemplate) {
            return this._id + "={read=" + this._readPreference + ";write=" + this._writePreference + "}";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this._id).append(";t;");
        Iterator i = this.getSelection();
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            sb.append(entry.getKey().toString() + "=" + entry.getValue() + ";");
        }
        return sb.toString();
    }

    public String toNiceString() {
        StringBuffer sb = new StringBuffer();
        PoolClassAttraction attr = this;
        sb.append(Formats.field((String)attr.getPool(), (int)10, (int)2)).append(Formats.field((String)attr.getOrganization(), (int)10, (int)2)).append(Formats.field((String)attr.getStorageClass(), (int)30, (int)2));
        int p = attr.getReadPreference();
        String pp = p <= 0 ? "-" : "" + p;
        sb.append(Formats.field((String)pp, (int)8, (int)4));
        p = attr.getWritePreference();
        pp = p <= 0 ? "-" : "" + p;
        sb.append(Formats.field((String)pp, (int)8, (int)4));
        return sb.toString();
    }

    public static void main(String[] args) throws Exception {
        PoolClassAttraction pca = null;
        TreeSet<PoolClassAttraction> r_read = new TreeSet<PoolClassAttraction>(comparatorForWrite);
        TreeSet<PoolClassAttraction> r_write = new TreeSet<PoolClassAttraction>(comparatorForRead);
        pca = new PoolClassAttraction("pool-a", "OSM", "MAIN:raw");
        pca.setPreferences(1, 4);
        r_read.add(pca);
        r_write.add(pca);
        pca = new PoolClassAttraction("pool-a", "OSM", "MAIN:raw");
        pca.setPreferences(2, 3);
        r_read.add(pca);
        r_write.add(pca);
        pca = new PoolClassAttraction("pool-b", "OSM", "MAIN:raw");
        pca.setPreferences(2, 3);
        r_read.add(pca);
        r_write.add(pca);
        Iterator i = null;
        i = r_read.iterator();
        while (i.hasNext()) {
            System.out.println("Read : " + i.next());
        }
        i = r_write.iterator();
        while (i.hasNext()) {
            System.out.println("Write : " + i.next());
        }
    }

    public static class PoolClassComparator
    implements Comparator {
        private boolean _forWrite = true;

        private PoolClassComparator(boolean forWrite) {
            this._forWrite = forWrite;
        }

        public int compare(Object a, Object b) {
            if (!(a instanceof PoolClassAttraction) || !(b instanceof PoolClassAttraction)) {
                throw new ClassCastException("Can only compare : " + this.getClass());
            }
            PoolClassAttraction pca = (PoolClassAttraction)a;
            PoolClassAttraction pcb = (PoolClassAttraction)b;
            int intA = 0;
            int intB = 0;
            if (this._forWrite) {
                intA = pca.getWritePreference();
                intB = pcb.getWritePreference();
            } else {
                intA = pca.getReadPreference();
                intB = pcb.getReadPreference();
            }
            return intA == intB ? pca._id.compareTo(pcb._id) : (intA < intB ? 1 : -1);
        }
    }
}

