/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.vehicles;

import diskCacheV111.util.PnfsId;
import diskCacheV111.vehicles.PoolMessage;
import diskCacheV111.vehicles.StorageInfo;

public class Pool2PoolTransferMsg
extends PoolMessage {
    public static final int UNDETERMINED = 0;
    public static final int PRECIOUS = 1;
    public static final int CACHED = 2;
    private PnfsId _pnfsId = null;
    private StorageInfo _storageInfo = null;
    private String _destinationPoolName = null;
    private int _destinationFileStatus = 0;
    private static final long serialVersionUID = -4227857007512530410L;

    public Pool2PoolTransferMsg(String sourcePoolName, String destinationPoolName, PnfsId pnfsId, StorageInfo storageInfo) {
        super(sourcePoolName);
        this._pnfsId = pnfsId;
        this._storageInfo = storageInfo;
        this._destinationPoolName = destinationPoolName;
        this.setReplyRequired(true);
    }

    public PnfsId getPnfsId() {
        return this._pnfsId;
    }

    public StorageInfo getStorageInfo() {
        return this._storageInfo;
    }

    public String getSourcePoolName() {
        return this.getPoolName();
    }

    public String getDestinationPoolName() {
        return this._destinationPoolName;
    }

    public void setDestinationFileStatus(int status) {
        this._destinationFileStatus = status;
    }

    public int getDestinationFileStatus() {
        return this._destinationFileStatus;
    }

    @Override
    public String toString() {
        return this.getPoolName() + ";pnfsid=" + this._pnfsId + ";mode=" + (this._destinationFileStatus == 0 ? "Undetermined" : (this._destinationFileStatus == 1 ? "Precious" : "Cached"));
    }
}

