/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.vehicles;

import diskCacheV111.util.FileMetaData;
import diskCacheV111.util.PnfsId;
import diskCacheV111.vehicles.Message;
import java.util.Set;
import org.dcache.namespace.FileAttribute;
import org.dcache.util.Checksum;
import org.dcache.vehicles.FileAttributes;
import org.dcache.vehicles.PnfsGetFileAttributes;

public class PnfsGetFileMetaDataMessage
extends PnfsGetFileAttributes {
    private FileMetaData _metaData = null;
    private boolean _resolve = true;
    private boolean _checksumsRequested = false;
    private Set<Checksum> _checksums = null;
    private static final long serialVersionUID = 1591894346369251468L;

    public PnfsGetFileMetaDataMessage() {
        super((PnfsId)null, FileMetaData.getKnownFileAttributes());
        this._attributes.add(FileAttribute.PNFSID);
        this.setReplyRequired(true);
    }

    public PnfsGetFileMetaDataMessage(Set<FileAttribute> attr) {
        super((PnfsId)null, FileMetaData.getKnownFileAttributes());
        this._attributes.add(FileAttribute.PNFSID);
        this._attributes.addAll(attr);
        this.setReplyRequired(true);
    }

    public PnfsGetFileMetaDataMessage(PnfsId pnfsId) {
        super(pnfsId, FileMetaData.getKnownFileAttributes());
        this._attributes.add(FileAttribute.PNFSID);
        this.setReplyRequired(true);
    }

    @Override
    public void setFileAttributes(FileAttributes fileAttributes) {
        this._metaData = new FileMetaData(fileAttributes);
        if (fileAttributes.isDefined(FileAttribute.CHECKSUM)) {
            this._checksums = fileAttributes.getChecksums();
        }
        if (this._attributes != null) {
            super.setFileAttributes(fileAttributes);
        }
    }

    public FileMetaData getMetaData() {
        return this._fileAttributes == null ? null : new FileMetaData(this._fileAttributes);
    }

    public void setResolve(boolean resolve) {
        this._resolve = resolve;
    }

    public boolean resolve() {
        return this._resolve;
    }

    public Set<Checksum> getChecksums() {
        return this._fileAttributes == null || !this._fileAttributes.isDefined(FileAttribute.CHECKSUM) ? null : this._fileAttributes.getChecksums();
    }

    public boolean isChecksumsRequested() {
        return this._checksumsRequested;
    }

    public void setChecksumsRequested(boolean checksumsRequested) {
        this._checksumsRequested = checksumsRequested;
        if (checksumsRequested) {
            this._attributes.add(FileAttribute.CHECKSUM);
        } else {
            this._attributes.remove((Object)FileAttribute.CHECKSUM);
        }
    }

    public void requestChecksum() {
        this._checksumsRequested = true;
        this._attributes.add(FileAttribute.CHECKSUM);
    }

    @Override
    public Set<FileAttribute> getRequestedAttributes() {
        Set<FileAttribute> attributes = this._attributes;
        if (attributes == null) {
            attributes = FileMetaData.getKnownFileAttributes();
            if (this._checksumsRequested) {
                attributes.add(FileAttribute.CHECKSUM);
            }
        }
        return attributes;
    }

    @Override
    public boolean invalidates(Message message) {
        return false;
    }

    @Override
    public boolean fold(Message message) {
        PnfsGetFileMetaDataMessage other;
        if (message.getClass().equals(PnfsGetFileMetaDataMessage.class) && (other = (PnfsGetFileMetaDataMessage)message).resolve() == this.resolve()) {
            return super.fold(message);
        }
        return false;
    }
}

