/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.vehicles;

import diskCacheV111.util.PnfsId;
import diskCacheV111.vehicles.InfoMessage;
import diskCacheV111.vehicles.StorageInfo;
import org.antlr.stringtemplate.StringTemplate;

public class PnfsFileInfoMessage
extends InfoMessage {
    private PnfsId _pnfsId = null;
    private String _path = "Unknown";
    private long _fileSize = 0L;
    private StorageInfo _storageInfo = null;
    private static final long serialVersionUID = -7761016173336078097L;

    public PnfsFileInfoMessage(String messageType, String cellType, String cellName, PnfsId pnfsId) {
        super(messageType, cellType, cellName);
        this._pnfsId = pnfsId;
    }

    public String getFileInfo() {
        return "[" + this._pnfsId + "," + this._fileSize + "]" + " " + "[" + this._path + "] " + (this._storageInfo == null ? "<unknown>" : this._storageInfo.getStorageClass() + "@" + this._storageInfo.getHsm());
    }

    public void setFileSize(long fileSize) {
        this._fileSize = fileSize;
    }

    public long getFileSize() {
        return this._fileSize;
    }

    public PnfsId getPnfsId() {
        return this._pnfsId;
    }

    public void setPnfsId(PnfsId pnfsId) {
        this._pnfsId = pnfsId;
    }

    public void setStorageInfo(StorageInfo storageInfo) {
        this._storageInfo = storageInfo;
    }

    public StorageInfo getStorageInfo() {
        return this._storageInfo;
    }

    public String getPath() {
        return this._path;
    }

    public void setPath(String path) {
        this._path = path;
    }

    @Override
    public void fillTemplate(StringTemplate template) {
        super.fillTemplate(template);
        template.setAttribute("pnfsid", (Object)this.getPnfsId());
        template.setAttribute("path", (Object)this.getPath());
        template.setAttribute("filesize", (Object)this.getFileSize());
        template.setAttribute("storage", (Object)this.getStorageInfo());
    }
}

