/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.vehicles;

import diskCacheV111.util.PnfsId;
import diskCacheV111.vehicles.PnfsFileInfoMessage;
import diskCacheV111.vehicles.ProtocolInfo;
import org.antlr.stringtemplate.StringTemplate;

public class MoverInfoMessage
extends PnfsFileInfoMessage {
    private long _dataTransferred = 0L;
    private long _connectionTime = 0L;
    private ProtocolInfo _protocolInfo = null;
    private boolean _fileCreated = false;
    private String _initiator = "<undefined>";
    private String _client = "unknown";
    private static final long serialVersionUID = -7013160118909496211L;

    public MoverInfoMessage(String cellName, PnfsId pnfsId) {
        super("transfer", "pool", cellName, pnfsId);
    }

    public void setFileCreated(boolean created) {
        this._fileCreated = created;
    }

    public void setTransferAttributes(long dataTransferred, long connectionTime, ProtocolInfo protocolInfo) {
        this._dataTransferred = dataTransferred;
        this._connectionTime = connectionTime;
        this._protocolInfo = protocolInfo;
    }

    public void setInitiator(String transaction) {
        this._initiator = transaction;
    }

    public String getInitiator() {
        return this._initiator;
    }

    public long getDataTransferred() {
        return this._dataTransferred;
    }

    public long getConnectionTime() {
        return this._connectionTime;
    }

    public boolean isFileCreated() {
        return this._fileCreated;
    }

    public ProtocolInfo getProtocolInfo() {
        return this._protocolInfo;
    }

    public String getAdditionalInfo() {
        return this._dataTransferred + " " + this._connectionTime + " " + this._fileCreated + " {" + this._protocolInfo + "} [" + this._initiator + "] ";
    }

    @Override
    public String toString() {
        return this.getInfoHeader() + " " + this.getFileInfo() + " " + this.getAdditionalInfo() + this.getResult();
    }

    @Override
    public void fillTemplate(StringTemplate template) {
        super.fillTemplate(template);
        template.setAttribute("transferred", (Object)this._dataTransferred);
        template.setAttribute("connectionTime", (Object)this._connectionTime);
        template.setAttribute("created", (Object)this._fileCreated);
        template.setAttribute("protocol", (Object)this._protocolInfo);
        template.setAttribute("initiator", (Object)this._initiator);
    }
}

