/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.vehicles;

import diskCacheV111.util.Batchable;
import diskCacheV111.util.IoBatchable;
import diskCacheV111.util.JobScheduler;
import diskCacheV111.vehicles.IoJobInfo;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;

public class JobInfo
implements Serializable {
    private String _client = "<unknown>";
    private long _clientId = 0L;
    private long _submitTime = 0L;
    private long _startTime = 0L;
    private String _status = null;
    private long _jobId = 0L;
    private static final SimpleDateFormat __format = new SimpleDateFormat("MM/dd-HH:mm:ss");
    private static final long serialVersionUID = 5209798222006083955L;

    public static JobInfo newInstance(JobScheduler.Job job) {
        Runnable run = job.getTarget();
        if (run instanceof IoBatchable) {
            IoJobInfo info = new IoJobInfo(job);
            info.setClient(((Batchable)run).getClient(), ((Batchable)run).getClientId());
            info.setIoInfo(((IoBatchable)run).getPnfsId(), ((IoBatchable)run).getBytesTransferred(), ((IoBatchable)run).getTransferTime(), ((IoBatchable)run).getLastTransferred());
            return info;
        }
        if (run instanceof Batchable) {
            JobInfo info = new JobInfo(job);
            info.setClient(((Batchable)run).getClient(), ((Batchable)run).getClientId());
            return info;
        }
        return new JobInfo(job);
    }

    JobInfo(JobScheduler.Job job) {
        this._submitTime = job.getSubmitTime();
        this._startTime = job.getStartTime();
        this._status = job.getStatusString();
        this._jobId = job.getJobId();
    }

    public void setClient(String clientName, long clientId) {
        this._client = clientName;
        this._clientId = clientId;
    }

    public String getClientName() {
        return this._client;
    }

    public long getClientId() {
        return this._clientId;
    }

    public long getStartTime() {
        return this._startTime;
    }

    public long getSubmitTime() {
        return this._submitTime;
    }

    public String getStatus() {
        return this._status;
    }

    public long getJobId() {
        return this._jobId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this._jobId).append(";");
        sb.append(this._client).append(":").append(this._clientId);
        SimpleDateFormat simpleDateFormat = __format;
        synchronized (simpleDateFormat) {
            sb.append(";").append(__format.format(new Date(this._startTime))).append(";").append(__format.format(new Date(this._submitTime))).append(";").append(this._status).append(";");
        }
        return sb.toString();
    }
}

