/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.vehicles;

import diskCacheV111.util.JobScheduler;
import diskCacheV111.util.PnfsId;
import diskCacheV111.vehicles.JobInfo;

public class IoJobInfo
extends JobInfo {
    private long _bytesTransferred = 0L;
    private long _transferTime = 0L;
    private long _lastTransferred = 0L;
    private PnfsId _pnfsId = null;
    private static final long serialVersionUID = -7987228538353684951L;

    public IoJobInfo(JobScheduler.Job job) {
        super(job);
    }

    public void setIoInfo(PnfsId pnfsId, long bytesTransferred, long transferTime, long lastTransferred) {
        this._pnfsId = pnfsId;
        this._bytesTransferred = bytesTransferred;
        this._transferTime = transferTime;
        this._lastTransferred = lastTransferred;
    }

    public long getTransferTime() {
        return this._transferTime;
    }

    public long getBytesTransferred() {
        return this._bytesTransferred;
    }

    public long getLastTransferred() {
        return this._lastTransferred;
    }

    public PnfsId getPnfsId() {
        return this._pnfsId;
    }

    @Override
    public String toString() {
        return super.toString() + this._pnfsId + ";B=" + this._bytesTransferred + ";T=" + this._transferTime + ";L=" + (System.currentTimeMillis() - this._lastTransferred) / 1000L + ";";
    }
}

