/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.vehicles;

import diskCacheV111.vehicles.IpProtocolInfo;
import java.net.InetSocketAddress;

public class HttpProtocolInfo
implements IpProtocolInfo {
    private String _name = "Unkown";
    private int _minor = 0;
    private int _major = 0;
    private InetSocketAddress _clientSocketAddress;
    private final String[] _hosts;
    private int _port = 0;
    private long _transferTime = 0L;
    private long _bytesTransferred = 0L;
    private int _sessionId = 0;
    private boolean _writeAllowed = false;
    private String httpDoorCellName;
    private String httpDoorDomainName;
    private String path;
    private static final long serialVersionUID = 8002182588464502270L;

    public HttpProtocolInfo(String protocol, int major, int minor, InetSocketAddress clientSocketAddress, String httpDoorCellName, String httpDoorDomainName, String path) {
        this._name = protocol;
        this._minor = minor;
        this._major = major;
        this._clientSocketAddress = clientSocketAddress;
        this._hosts = new String[]{this._clientSocketAddress.getAddress().getHostAddress()};
        this._port = this._clientSocketAddress.getPort();
        this.httpDoorCellName = httpDoorCellName;
        this.httpDoorDomainName = httpDoorDomainName;
        this.path = path;
    }

    public String getHttpDoorCellName() {
        return this.httpDoorCellName;
    }

    public String getHttpDoorDomainName() {
        return this.httpDoorDomainName;
    }

    public String getPath() {
        return this.path;
    }

    public int getSessionId() {
        return this._sessionId;
    }

    public void setSessionId(int sessionId) {
        this._sessionId = sessionId;
    }

    @Override
    public String getProtocol() {
        return this._name;
    }

    @Override
    public int getMinorVersion() {
        return this._minor;
    }

    @Override
    public int getMajorVersion() {
        return this._major;
    }

    @Override
    public String getVersionString() {
        return this._name + "-" + this._major + "." + this._minor;
    }

    @Override
    public int getPort() {
        return this._port;
    }

    @Override
    public String[] getHosts() {
        return this._hosts;
    }

    public void setBytesTransferred(long bytesTransferred) {
        this._bytesTransferred = bytesTransferred;
    }

    public void setTransferTime(long transferTime) {
        this._transferTime = transferTime;
    }

    public long getTransferTime() {
        return this._transferTime;
    }

    public long getBytesTransferred() {
        return this._bytesTransferred;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getVersionString());
        for (int i = 0; i < this._hosts.length; ++i) {
            sb.append(',').append(this._hosts[i]);
        }
        sb.append(':').append(this._port);
        sb.append(':').append(this.httpDoorCellName);
        sb.append(':').append(this.httpDoorDomainName);
        sb.append(':').append(this.path);
        return sb.toString();
    }

    public boolean isWriteAllowed() {
        return this._writeAllowed;
    }

    public void setAllowWrite(boolean allow) {
        this._writeAllowed = allow;
    }

    @Override
    public InetSocketAddress getSocketAddress() {
        return this._clientSocketAddress;
    }
}

