/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.vehicles;

import diskCacheV111.util.AccessLatency;
import diskCacheV111.util.RetentionPolicy;
import diskCacheV111.vehicles.StorageInfo;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericStorageInfo
implements StorageInfo {
    private static Logger _logger = LoggerFactory.getLogger(GenericStorageInfo.class);
    static final long serialVersionUID = 2089636591513548893L;
    private AccessLatency _accessLatency = StorageInfo.DEFAULT_ACCESS_LATENCY;
    private RetentionPolicy _retentionPolicy = StorageInfo.DEFAULT_RETENTION_POLICY;
    private HashMap<String, String> _keyHash = new HashMap();
    private ArrayList<URI> _locations = new ArrayList();
    private boolean _setHsm = false;
    private boolean _setStorageClass = false;
    private boolean _setBitFileId = false;
    private boolean _setRetentionPolicy = false;
    private boolean _setAccessLatency = false;
    private boolean _setLocation = false;
    private boolean _isNew = true;
    private boolean _isStored = false;
    private String _hsm = null;
    private String _cacheClass = null;
    private long _fileSize = 0L;
    private String _storageClass = null;
    @Deprecated
    private String _bitfileId = null;

    public GenericStorageInfo() {
    }

    public GenericStorageInfo(String hsm, String storageClass) {
        this._storageClass = storageClass;
        this._hsm = hsm;
    }

    @Deprecated
    public void addKeys(Map<String, String> keys) {
        this._keyHash.putAll(keys);
    }

    @Override
    public void addLocation(URI newLocation) {
        this._locations.add(newLocation);
    }

    @Override
    public AccessLatency getAccessLatency() {
        return this._accessLatency;
    }

    @Override
    @Deprecated
    public String getBitfileId() {
        return this._bitfileId == null ? "<Unknown>" : this._bitfileId;
    }

    @Override
    public String getCacheClass() {
        return this._cacheClass;
    }

    @Override
    public long getFileSize() {
        return this._fileSize;
    }

    @Override
    public String getHsm() {
        return this._hsm;
    }

    @Override
    @Deprecated
    public String getKey(String key) {
        return this._keyHash.get(key);
    }

    @Override
    @Deprecated
    public Map<String, String> getMap() {
        return new HashMap<String, String>(this._keyHash);
    }

    @Override
    public RetentionPolicy getRetentionPolicy() {
        return this._retentionPolicy;
    }

    @Override
    public String getStorageClass() {
        return this._storageClass;
    }

    @Override
    public boolean isCreatedOnly() {
        return this._isNew;
    }

    @Override
    public boolean isSetAccessLatency() {
        return this._setAccessLatency;
    }

    @Override
    public void isSetAccessLatency(boolean isSet) {
        this._setAccessLatency = isSet;
    }

    @Override
    public boolean isSetAddLocation() {
        return this._setLocation;
    }

    @Override
    public void isSetAddLocation(boolean isSet) {
        this._setLocation = isSet;
    }

    @Override
    @Deprecated
    public boolean isSetBitFileId() {
        return this._setBitFileId;
    }

    @Override
    @Deprecated
    public void isSetBitFileId(boolean isSet) {
        this._setBitFileId = isSet;
    }

    @Override
    public void setCacheClass(String newCacheClass) {
        this._cacheClass = newCacheClass;
    }

    @Override
    public boolean isSetHsm() {
        return this._setHsm;
    }

    @Override
    public void isSetHsm(boolean isSet) {
        this._setHsm = isSet;
    }

    @Override
    public boolean isSetRetentionPolicy() {
        return this._setRetentionPolicy;
    }

    @Override
    public void isSetRetentionPolicy(boolean isSet) {
        this._setRetentionPolicy = isSet;
    }

    @Override
    public boolean isSetStorageClass() {
        return this._setStorageClass;
    }

    @Override
    public void isSetStorageClass(boolean isSet) {
        this._setStorageClass = isSet;
    }

    @Override
    public boolean isStored() {
        return this._isStored || this._locations != null && !this._locations.isEmpty();
    }

    @Override
    public List<URI> locations() {
        return this._locations;
    }

    @Override
    public void setAccessLatency(AccessLatency accessLatency) {
        this._accessLatency = accessLatency;
    }

    @Override
    @Deprecated
    public void setBitfileId(String bitfileId) {
        this._bitfileId = bitfileId;
    }

    @Override
    public void setFileSize(long fileSize) {
        this._fileSize = fileSize;
    }

    @Override
    public void setHsm(String newHsm) {
        this._hsm = newHsm;
    }

    @Override
    public void setIsNew(boolean isNew) {
        this._isNew = isNew;
    }

    @Override
    @Deprecated
    public void setKey(String key, String value) {
        if (value == null) {
            this._keyHash.remove(key);
        } else {
            this._keyHash.put(key, value);
        }
    }

    @Override
    public void setRetentionPolicy(RetentionPolicy retentionPolicy) {
        this._retentionPolicy = retentionPolicy;
    }

    @Override
    public void setStorageClass(String newStorageClass) {
        this._storageClass = newStorageClass;
    }

    @Override
    @Deprecated
    public void setIsStored(boolean isStored) {
        this._isStored = isStored;
    }

    public String toString() {
        String sc = this.getStorageClass();
        String cc = this.getCacheClass();
        String hsm = this.getHsm();
        AccessLatency ac = this.getAccessLatency();
        RetentionPolicy rp = this.getRetentionPolicy();
        StringBuilder sb = new StringBuilder();
        sb.append("size=").append(this.getFileSize()).append(";new=").append(this.isCreatedOnly()).append(";stored=").append(this.isStored()).append(";sClass=").append(sc == null ? "-" : sc).append(";cClass=").append(cc == null ? "-" : cc).append(";hsm=").append(hsm == null ? "-" : hsm).append(";accessLatency=").append(ac == null ? "-" : ac.toString()).append(";retentionPolicy=").append(rp == null ? "-" : rp.toString()).append(";");
        if (this._keyHash != null) {
            for (Map.Entry entry : this._keyHash.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                sb.append(key).append("=").append(value).append(";");
            }
        }
        if (this._locations != null) {
            for (URI uRI : this._locations) {
                sb.append(uRI).append(";");
            }
        }
        return sb.toString();
    }

    public int hashCode() {
        HashSet<URI> ourLocations = new HashSet<URI>(this.locations());
        return this.getAccessLatency().hashCode() ^ this.getRetentionPolicy().hashCode() ^ ((Object)ourLocations).hashCode() ^ (int)this.getFileSize() ^ this.getStorageClass().hashCode() ^ (this.isStored() ? 1 : 0) ^ (this.isCreatedOnly() ? 2 : 0);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GenericStorageInfo)) {
            return false;
        }
        GenericStorageInfo other = (GenericStorageInfo)o;
        if (!other.getAccessLatency().equals((Object)this.getAccessLatency())) {
            return false;
        }
        if (!other.getRetentionPolicy().equals((Object)this.getRetentionPolicy())) {
            return false;
        }
        HashSet<URI> ourLocations = new HashSet<URI>(this.locations());
        HashSet<URI> otherLocations = new HashSet<URI>(other.locations());
        if (!((Object)otherLocations).equals(ourLocations)) {
            return false;
        }
        if (this.locations().isEmpty()) {
            if (other.getBitfileId() != null && this.getBitfileId() != null && !other.getBitfileId().equals(this.getBitfileId())) {
                return false;
            }
            if (other.getBitfileId() != null && this.getBitfileId() == null) {
                return false;
            }
            if (other.getBitfileId() == null && this.getBitfileId() != null) {
                return false;
            }
        }
        if (!other.getHsm().equals(this.getHsm())) {
            return false;
        }
        if (other.getCacheClass() != null && this.getCacheClass() != null && !other.getCacheClass().equals(this.getCacheClass())) {
            return false;
        }
        if (other.getCacheClass() == null && this.getCacheClass() != null) {
            return false;
        }
        if (other.getCacheClass() != null && this.getCacheClass() == null) {
            return false;
        }
        if (!other._keyHash.equals(this._keyHash)) {
            return false;
        }
        if (other.getFileSize() != this.getFileSize()) {
            return false;
        }
        if (!other.getStorageClass().equals(this.getStorageClass())) {
            return false;
        }
        if (other.isStored() != this.isStored()) {
            return false;
        }
        return other.isCreatedOnly() == this.isCreatedOnly();
    }

    Object readResolve() {
        if (this._accessLatency == null) {
            this._accessLatency = AccessLatency.NEARLINE;
        }
        if (this._retentionPolicy == null) {
            this._retentionPolicy = RetentionPolicy.CUSTODIAL;
        }
        if (this._locations == null) {
            this._locations = new ArrayList();
        }
        return this;
    }

    @Override
    public GenericStorageInfo clone() {
        try {
            GenericStorageInfo copy = (GenericStorageInfo)super.clone();
            copy._keyHash = (HashMap)copy._keyHash.clone();
            copy._locations = (ArrayList)copy._locations.clone();
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Failed to clone storage info: " + e.getMessage());
        }
    }

    public static StorageInfo valueOf(String storeUnit, String cacheClass) throws IllegalArgumentException {
        GenericStorageInfo si;
        if (storeUnit.equals("*")) {
            si = new GenericStorageInfo();
        } else {
            String[] unitParts = storeUnit.split("@");
            if (unitParts.length != 2) {
                throw new IllegalArgumentException("Invalid format: expected<x:y@z> got <" + storeUnit + ">");
            }
            si = new GenericStorageInfo(unitParts[1], unitParts[0]);
        }
        if (!cacheClass.equals("*")) {
            si.setCacheClass(cacheClass);
        }
        return si;
    }
}

