/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.vehicles;

import diskCacheV111.vehicles.PnfsFileInfoMessage;
import javax.security.auth.Subject;
import org.antlr.stringtemplate.StringTemplate;
import org.dcache.auth.Subjects;

public class DoorRequestInfoMessage
extends PnfsFileInfoMessage {
    private long _transactionTime = 0L;
    private String _client = "unknown";
    private static final long serialVersionUID = 2469895982145157834L;

    public DoorRequestInfoMessage(String cellName) {
        super("request", "door", cellName, null);
    }

    public DoorRequestInfoMessage(String cellName, String action) {
        super(action, "door", cellName, null);
    }

    public void setTransactionDuration(long duration) {
        this._transactionTime = duration;
    }

    public long getTransactionDuration() {
        return this._transactionTime;
    }

    @Override
    public String toString() {
        return this.getInfoHeader() + " [" + this.getUserInfo() + "] " + this.getFileInfo() + " " + this._transactionTime + " " + this.getTimeQueued() + " " + this.getResult();
    }

    public String getClient() {
        return this._client;
    }

    public void setClient(String client) {
        this._client = client;
    }

    public String getOwner() {
        Subject subject = this.getSubject();
        String owner = Subjects.getDn((Subject)subject);
        if (owner == null) {
            owner = Subjects.getUserName((Subject)subject);
        }
        return owner;
    }

    public int getGid() {
        long[] gids = Subjects.getGids((Subject)this.getSubject());
        return gids.length > 0 ? (int)gids[0] : -1;
    }

    public int getUid() {
        long[] uids = Subjects.getUids((Subject)this.getSubject());
        return uids.length > 0 ? (int)uids[0] : -1;
    }

    public String getUserInfo() {
        return "\"" + this.getOwner() + "\":" + this.getUid() + ":" + this.getGid() + ":" + this._client;
    }

    @Override
    public void fillTemplate(StringTemplate template) {
        super.fillTemplate(template);
        template.setAttribute("transactionTime", (Object)this._transactionTime);
        template.setAttribute("uid", this.getUid());
        template.setAttribute("gid", this.getGid());
        template.setAttribute("owner", (Object)this.getOwner());
        template.setAttribute("client", (Object)this.getClient());
    }
}

