/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.vehicles;

import diskCacheV111.vehicles.IpProtocolInfo;
import dmg.cells.nucleus.CellPath;
import java.net.InetSocketAddress;

public class DCapProtocolInfo
implements IpProtocolInfo {
    private final String _name;
    private final int _minor;
    private final int _major;
    private final String[] _hosts;
    private final int _port;
    private long _transferTime = 0L;
    private long _bytesTransferred = 0L;
    private int _sessionId = 0;
    private boolean _writeAllowed = false;
    private boolean _isPassive = false;
    private CellPath _door = null;
    private static final long serialVersionUID = 7432555710192378884L;

    public DCapProtocolInfo(String protocol, int major, int minor, String[] hosts, int port) {
        this._name = protocol;
        this._minor = minor;
        this._major = major;
        this._hosts = new String[hosts.length];
        System.arraycopy(hosts, 0, this._hosts, 0, hosts.length);
        this._port = port;
    }

    public DCapProtocolInfo(String protocol, int major, int minor, String host, int port) {
        this(protocol, major, minor, new String[]{host}, port);
    }

    public int getSessionId() {
        return this._sessionId;
    }

    public void setSessionId(int sessionId) {
        this._sessionId = sessionId;
    }

    @Override
    public String getProtocol() {
        return this._name;
    }

    @Override
    public int getMinorVersion() {
        return this._minor;
    }

    @Override
    public int getMajorVersion() {
        return this._major;
    }

    @Override
    public String getVersionString() {
        return this._name + "-" + this._major + "." + this._minor;
    }

    @Override
    public int getPort() {
        return this._port;
    }

    @Override
    public String[] getHosts() {
        return this._hosts;
    }

    public void setBytesTransferred(long bytesTransferred) {
        this._bytesTransferred = bytesTransferred;
    }

    public void setTransferTime(long transferTime) {
        this._transferTime = transferTime;
    }

    public long getTransferTime() {
        return this._transferTime;
    }

    public long getBytesTransferred() {
        return this._bytesTransferred;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getVersionString());
        for (int i = 0; i < this._hosts.length; ++i) {
            sb.append(",").append(this._hosts[i]);
        }
        sb.append(":").append(this._port);
        return sb.toString();
    }

    public boolean isWriteAllowed() {
        return this._writeAllowed;
    }

    public void setAllowWrite(boolean allow) {
        this._writeAllowed = allow;
    }

    public boolean isPassive() {
        return this._isPassive;
    }

    public void isPassive(boolean passive) {
        this._isPassive = passive;
    }

    public CellPath door() {
        return this._door;
    }

    public void door(CellPath door) {
        this._door = door;
    }

    @Override
    public InetSocketAddress getSocketAddress() {
        return null;
    }
}

