/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.vehicles;

import java.io.Serializable;
import java.util.StringTokenizer;

public class CacheStatistics
implements Serializable,
Comparable<CacheStatistics> {
    private int _version = 1;
    private int _totalAccesses = 0;
    private long _accessTime = 0L;
    private float _score = 0.0f;
    private float _halfLife = 0.0f;
    private static final double __logOneHalf = Math.log(0.5);
    private static final long serialVersionUID = 3951762169312269595L;

    public CacheStatistics(int totalAccesses, long accessTime, float score, float halfLife) {
        this._totalAccesses = totalAccesses;
        this._accessTime = accessTime;
        this._score = score;
        this._halfLife = halfLife;
    }

    public CacheStatistics() {
        this(0, 0L, 0.0f, 0.0f);
    }

    public CacheStatistics(String pnfsString) {
        StringTokenizer st = new StringTokenizer(pnfsString, ",");
        try {
            this._version = Integer.parseInt(st.nextToken());
        }
        catch (Exception e) {
            throw new IllegalArgumentException(pnfsString);
        }
        if (this._version > 2) {
            throw new IllegalArgumentException("statistics version mismatch, got " + this._version + " expected <= 2");
        }
        if (st.countTokens() != 4) {
            throw new IllegalArgumentException(pnfsString);
        }
        try {
            this._totalAccesses = Integer.parseInt(st.nextToken());
            this._accessTime = Long.parseLong(st.nextToken());
            this._score = new Float(st.nextToken()).floatValue();
            this._halfLife = new Float(st.nextToken()).floatValue();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(pnfsString);
        }
    }

    public CacheStatistics(int version, int totalAccesses, long accessTime, float score, float halfLife) {
        this._version = version;
        this._totalAccesses = totalAccesses;
        this._accessTime = accessTime;
        this._score = score;
        this._halfLife = halfLife;
    }

    public int getTotalAccesses() {
        return this._totalAccesses;
    }

    public void setTotalAccesses(int totalAccesses) {
        this._totalAccesses = totalAccesses;
    }

    public long getAccessTime() {
        return this._accessTime;
    }

    public void setAccessTime(long accessTime) {
        this._accessTime = accessTime;
    }

    public float getScore() {
        return this._score;
    }

    public void setScore(float score) {
        this._score = score;
    }

    public float getHalfLife() {
        return this._halfLife;
    }

    public void setHalfLife(float halfLife) {
        this._halfLife = halfLife;
    }

    public void setVersion(int version) {
        this._version = version;
    }

    public int getVersion() {
        return this._version;
    }

    public String toPnfsString() {
        return "" + this._version + "," + this._totalAccesses + "," + this._accessTime + "," + this._score + "," + this._halfLife;
    }

    public String toString() {
        return this.toPnfsString();
    }

    public double age(float then, float now) {
        if (this._halfLife == 0.0f) {
            return 0.0;
        }
        return Math.exp(__logOneHalf * (double)(now - then) / (double)this._halfLife);
    }

    public float currentValue() {
        return this.currentValue(System.currentTimeMillis());
    }

    public float currentValue(long now) {
        if (this._accessTime == 0L) {
            return 0.0f;
        }
        return (float)((double)this._score * this.age(this._accessTime, now));
    }

    public void markAccessed(long accessTime) {
        ++this._totalAccesses;
        if (this._accessTime == 0L) {
            this._score = 1.0f;
        } else {
            this._score = (float)((double)this._score * this.age(this._accessTime, accessTime) + 1.0);
            this._accessTime = accessTime;
        }
    }

    @Override
    public int compareTo(CacheStatistics other) {
        if (this._totalAccesses == other.getTotalAccesses()) {
            return this._accessTime > other.getAccessTime() ? -1 : (this._accessTime == other.getAccessTime() ? 0 : 1);
        }
        return this._totalAccesses > other.getTotalAccesses() ? -1 : (this._totalAccesses == other.getTotalAccesses() ? 0 : 1);
    }

    public static void main(String[] args) {
        CacheStatistics s = new CacheStatistics(args[0]);
        System.out.println(s.toPnfsString());
    }
}

