/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.util;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dcache.util.Glob;

public class VOInfo
implements Serializable {
    static final long serialVersionUID = -8014669884189610627L;
    private static Pattern p1 = Pattern.compile("(.*)/Role=(.*)");
    private static Pattern p2 = Pattern.compile("(.*)()");
    private String voGroup;
    private String voRole;

    public VOInfo(String pattern) {
        Matcher m = this.getMatcher(pattern);
        this.voGroup = m.group(1);
        this.voRole = this.mapRoleToGlob(m.group(2));
    }

    private String mapRoleToGlob(String roleInFqan) {
        return roleInFqan.isEmpty() ? "*" : roleInFqan;
    }

    private Matcher getMatcher(String pattern) {
        Matcher m = p1.matcher(pattern);
        if (m.matches()) {
            return m;
        }
        m = p2.matcher(pattern);
        if (m.matches()) {
            return m;
        }
        throw new RuntimeException("Failed to find a matcher for FQAN pattern: " + pattern);
    }

    public VOInfo(String voGroup, String voRole) {
        if (voGroup == null) {
            throw new IllegalArgumentException("null group");
        }
        this.voGroup = voGroup;
        this.voRole = voRole;
    }

    public String toString() {
        return this.voGroup + ":" + this.voRole;
    }

    public String getVoGroup() {
        return this.voGroup;
    }

    public String getVoRole() {
        return this.voRole;
    }

    public int hashCode() {
        return this.voGroup.hashCode() ^ this.voRole.hashCode();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof VOInfo)) {
            return false;
        }
        VOInfo voinfo = (VOInfo)o;
        return this.voGroup.equals(voinfo.voGroup) && this.voRole.equals(voinfo.voRole);
    }

    public boolean match(String group, String role) {
        boolean roleMatches;
        if (this.voRole != null) {
            Glob rolePattern = new Glob(this.voRole);
            roleMatches = rolePattern.matches(role == null ? "null" : role);
        } else {
            roleMatches = true;
        }
        Glob groupPattern = new Glob(this.voGroup);
        return groupPattern.matches(group == null ? "null" : group) && roleMatches;
    }
}

