/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.util;

import diskCacheV111.util.FutureTimedTask;
import diskCacheV111.util.ThreadPool;
import dmg.cells.nucleus.CDC;
import dmg.cells.nucleus.CellAdapter;
import dmg.cells.nucleus.CellMessage;
import dmg.util.Args;
import java.io.PrintWriter;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.dcache.util.FireAndForgetTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadManager
extends CellAdapter
implements ThreadPool,
ThreadFactory {
    private static final Logger _log = LoggerFactory.getLogger(ThreadManager.class);
    private Args _opt = this.getArgs();
    private static ThreadPoolTimedExecutor executor;
    public static int THREAD_COUNT;
    ScheduledExecutorService delaychecker;
    public static int DELAY_CANCEL_TIME;
    private static long toolong;
    private static ThreadManager threadmanager;
    private static int num_threads;
    public String hh_set_NumThreads = "<numthreads>";
    public String fh_set_NumThreads = " set NumThreads <numthreads>\n        Sets the allowed number of threads. Same as set CorePoolSize.\n\n";
    public String hh_set_DelayCancelTime = "<timeout in seconds>";
    public String fh_set_DelayCancelTime = " set DelayCancelTime <timeout in seconds>\n        Sets the timeout for all threads.\n\n";
    public String hh_set_CorePoolSize = "<poolsize>";
    public String fh_set_CorePoolSize = " set CorePoolSize <poolsize>\n        Sets the allowed number of threads. Same as set NumThreads.\n\n";
    public String hh_set_KeepAliveTime = "<keeptime in seconds>";
    public String fh_set_KeepAliveTime = " set KeepAliveTime <keeptime in seconds>\n        Sets the time that an idle thread is kept.\n\n";

    public ThreadManager(String name, String args) throws Exception {
        super(name, args, false);
        try {
            THREAD_COUNT = this.setParam("num-threads", THREAD_COUNT);
            DELAY_CANCEL_TIME = this.setParam("thread-timeout", DELAY_CANCEL_TIME);
            toolong = 1000 * DELAY_CANCEL_TIME;
            _log.info(this.toString() + " starting with " + THREAD_COUNT + " threads and timeout " + DELAY_CANCEL_TIME);
            executor = new ThreadPoolTimedExecutor(THREAD_COUNT, THREAD_COUNT, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue(), this);
            this.delaychecker = Executors.newScheduledThreadPool(THREAD_COUNT, this);
            this.useInterpreter(true);
            this.addCommandListener(this);
            this.start();
            _log.info(this.toString() + " started");
        }
        catch (Exception iae) {
            _log.warn(this.toString() + " couldn't start due to " + iae, (Throwable)iae);
            this.start();
            this.kill();
            throw iae;
        }
        this.setPrintoutLevel(3);
        _log.info(" Constructor finished");
    }

    public static ThreadManager getInstance() {
        return threadmanager;
    }

    public static ThreadPoolExecutor getExecutor() {
        return executor;
    }

    public static void execute(FutureTimedTask task) {
        ThreadPoolExecutor executor = ThreadManager.getExecutor();
        if (executor == null) {
            new Thread(task).start();
        } else {
            executor.execute(new FireAndForgetTask(task));
        }
    }

    public static void execute(final Runnable runnable) {
        final CDC cdc = new CDC();
        Runnable wrapper = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                cdc.restore();
                try {
                    runnable.run();
                }
                finally {
                    CDC.clear();
                }
            }
        };
        ThreadPoolExecutor executor = ThreadManager.getExecutor();
        if (executor == null) {
            new Thread(wrapper).start();
        } else {
            executor.execute(new FireAndForgetTask(wrapper));
        }
    }

    private String setParam(String name, String target) {
        String option;
        if (target == null) {
            target = "";
        }
        if ((option = this._opt.getOpt(name)) != null && option.length() > 0) {
            target = option;
        }
        _log.info("Using " + name + " : " + target);
        return target;
    }

    private int setParam(String name, int target) {
        String option = this._opt.getOpt(name);
        if (option != null && option.length() > 0) {
            try {
                target = Integer.parseInt(option);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        _log.info("Using " + name + " : " + target);
        return target;
    }

    private long setParam(String name, long target) {
        String option = this._opt.getOpt(name);
        if (option != null && option.length() > 0) {
            try {
                target = Integer.parseInt(option);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        _log.info("Using " + name + " : " + target);
        return target;
    }

    public String ac_help(Args args) throws Exception {
        StringBuffer sb = new StringBuffer(super.ac_info(args));
        return sb.toString();
    }

    public String ac_info(Args args) {
        StringBuffer sb = new StringBuffer(super.ac_info(args));
        sb.append("ActiveCount=" + executor.getActiveCount()).append("\n");
        sb.append("CompletedTaskCount=" + executor.getCompletedTaskCount()).append("\n");
        sb.append("CorePoolSize=" + executor.getCorePoolSize()).append("\n");
        sb.append("KeepAliveTime=" + executor.getKeepAliveTime(TimeUnit.SECONDS)).append("\n");
        sb.append("LargestPoolSize=" + executor.getLargestPoolSize()).append("\n");
        sb.append("MaximumPoolSize=" + executor.getMaximumPoolSize()).append("\n");
        sb.append("PoolSize=" + executor.getPoolSize()).append("\n");
        sb.append("TaskCount=" + executor.getTaskCount()).append("\n");
        sb.append("IsShutdown=" + executor.isShutdown()).append("\n");
        sb.append("IsTerminated=" + executor.isTerminated()).append("\n");
        sb.append("IsTerminating=" + executor.isTerminating()).append("\n");
        return sb.toString();
    }

    public String ac_set_NumThreads_$_1(Args args) {
        return this.ac_set_CorePoolSize_$_1(args);
    }

    public String ac_set_DelayCancelTime_$_1(Args args) {
        int time;
        DELAY_CANCEL_TIME = time = Integer.parseInt(args.argv(0));
        toolong = 1000 * DELAY_CANCEL_TIME;
        return "CancelTime set to " + DELAY_CANCEL_TIME + " seconds";
    }

    public String ac_set_CorePoolSize_$_1(Args args) {
        int size = Integer.parseInt(args.argv(0));
        executor.setCorePoolSize(size);
        THREAD_COUNT = size;
        return "CorePoolSize set to " + THREAD_COUNT;
    }

    public String ac_set_KeepAliveTime_$_1(Args args) {
        int time = Integer.parseInt(args.argv(0));
        executor.setKeepAliveTime(time, TimeUnit.SECONDS);
        return "KeepAliveTime set to " + time + " seconds";
    }

    public void getInfo(PrintWriter pw) {
        super.getInfo(pw);
        pw.println("ThreadManager");
    }

    public void cleanUp() {
        if (executor != null) {
            executor.shutdownNow();
        }
        if (this.delaychecker != null) {
            this.delaychecker.shutdownNow();
        }
    }

    public synchronized void messageArrived(CellMessage msg) {
    }

    public synchronized void Message(String msg1, String msg2) {
        _log.info("Message received");
    }

    @Override
    public synchronized Thread newThread(Runnable target) {
        return this.newThread(target, "ThreadManager-" + ++num_threads);
    }

    public Thread newThread(Runnable target, String name) {
        return this.getNucleus().newThread(target, name);
    }

    @Override
    public void invokeLater(Runnable runner, String name) throws IllegalArgumentException {
    }

    @Override
    public int getCurrentThreadCount() {
        return 0;
    }

    @Override
    public int getMaxThreadCount() {
        return ThreadManager.getExecutor().getMaximumPoolSize();
    }

    @Override
    public int getWaitingThreadCount() {
        return 0;
    }

    @Override
    public void setMaxThreadCount(int maxThreadCount) throws IllegalArgumentException {
        THREAD_COUNT = maxThreadCount;
        ThreadManager.getExecutor().setCorePoolSize(THREAD_COUNT);
        ThreadManager.getExecutor().setMaximumPoolSize(THREAD_COUNT);
    }

    static {
        THREAD_COUNT = 10;
        DELAY_CANCEL_TIME = 15;
        toolong = 1000 * DELAY_CANCEL_TIME;
        threadmanager = null;
        num_threads = 0;
    }

    public class TaskCanceller
    implements Runnable {
        private Future task;

        public TaskCanceller(Future task) {
            this.task = task;
        }

        public Future getFuture() {
            return this.task;
        }

        @Override
        public void run() {
            this.task.cancel(true);
        }
    }

    public static interface TimedFuture
    extends Future {
        public long getCreateTime();

        public void setTimer(Future var1);

        public void cancelTimer();

        public void abbreviateTask(boolean var1);
    }

    public class ThreadPoolTimedExecutor
    extends ThreadPoolExecutor {
        public ThreadPoolTimedExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue workQueue, ThreadFactory tfactory) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, (BlockingQueue<Runnable>)workQueue, tfactory);
        }

        @Override
        public void beforeExecute(Thread t, Runnable r) {
            if (r instanceof TimedFuture) {
                TimedFuture timedtask = (TimedFuture)((Object)r);
                long now = System.currentTimeMillis();
                long then = timedtask.getCreateTime();
                long timeleft = toolong - (now - then);
                if (timeleft < 0L) {
                    timedtask.abbreviateTask(true);
                } else {
                    TaskCanceller timerrunner = new TaskCanceller(timedtask);
                    ScheduledFuture<?> timer = ThreadManager.this.delaychecker.schedule(timerrunner, timeleft, TimeUnit.MILLISECONDS);
                    timedtask.setTimer(timer);
                }
            }
            super.beforeExecute(t, r);
        }

        @Override
        public void afterExecute(Runnable r, Throwable t) {
            super.afterExecute(r, t);
            if (r instanceof TimedFuture) {
                TimedFuture timedtask = (TimedFuture)((Object)r);
                timedtask.cancelTimer();
            }
        }
    }

    public static interface Skippable {
        public void setSkipProcessing(boolean var1);
    }
}

