/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.util;

import diskCacheV111.vehicles.PoolClassAttraction;
import diskCacheV111.vehicles.StorageInfo;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class StorageQueue {
    private String _poolName = null;
    private HashMap _storageQueue = new HashMap();
    private long _defaultExpiration = 14400000L;
    private int _defaultPending = 3;
    private int _defaultPreference = -1;
    public static final int DEFAULT_EXPIRATION = -1;
    public static final long DEFAULT_PENDING = -1L;
    public static final int DEFAULT_PREFERENCES = -1;

    public StorageQueue(String poolName) {
        this._poolName = poolName;
    }

    public void printSetup(PrintWriter pw) {
        for (StorageClassInfo classInfo : this._storageQueue.values()) {
            if (!classInfo.isDefined()) continue;
            pw.println("define class " + classInfo.getHsm() + " " + classInfo.getStorageClass() + " -pending=" + classInfo.getPending() + " -expire=" + classInfo.getExpiration() + " -writepref=" + classInfo.getWritePreference() + " -readpref=" + classInfo.getReadPreference());
        }
    }

    public int size() {
        return this._storageQueue.size();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (StorageClassInfo classInfo : this._storageQueue.values()) {
            sb.append(classInfo.toString()).append("\n");
            Enumeration reqs = classInfo.requests();
            while (reqs.hasMoreElements()) {
                sb.append("   ").append(reqs.nextElement().toString()).append("\n");
            }
        }
        return sb.toString();
    }

    public Iterator storageClassInfos() {
        return this._storageQueue.values().iterator();
    }

    public void setDefaultExpiration(long secs) {
        this._defaultExpiration = secs * 1000L;
    }

    public void setDefaultPending(int pending) {
        this._defaultPending = pending;
    }

    public synchronized StorageClassInfo defineStorageClass(String hsmName, String storageClass) {
        String composedName = storageClass + "@" + hsmName.toLowerCase();
        StorageClassInfo info = (StorageClassInfo)this._storageQueue.get(composedName);
        if (info == null) {
            info = new StorageClassInfo(hsmName, storageClass);
        }
        info.setDefined(true);
        this._storageQueue.put(composedName, info);
        return info;
    }

    public synchronized Enumeration getPnfsIdsOfClass(String storageClass) {
        Vector<String> v = new Vector<String>();
        StorageClassInfo info = (StorageClassInfo)this._storageQueue.get(storageClass);
        if (info == null) {
            return v.elements();
        }
        Enumeration e = info.getRequests();
        while (e.hasMoreElements()) {
            v.addElement(((StorageRequestInfo)e.nextElement()).getPnfsId());
        }
        return v.elements();
    }

    public synchronized Enumeration getRequestsOfClass(String storageClass) {
        Vector v = new Vector();
        StorageClassInfo info = (StorageClassInfo)this._storageQueue.get(storageClass);
        if (info == null) {
            return v.elements();
        }
        return info.getRequests();
    }

    public synchronized List getPreferenceHash() {
        ArrayList<PoolClassAttraction> list = new ArrayList<PoolClassAttraction>();
        Iterator e = this._storageQueue.values().iterator();
        StorageClassInfo info = null;
        PoolClassAttraction attr = null;
        while (e.hasNext()) {
            info = (StorageClassInfo)e.next();
            if (!info.isDefined()) continue;
            attr = new PoolClassAttraction(this._poolName, info.getHsm(), info.getStorageClass());
            attr.setPreferences(info.getReadPreference(), info.getWritePreference());
            list.add(attr);
        }
        return list;
    }

    public synchronized StorageClassInfo get(String hsmName, String storageClass) {
        return (StorageClassInfo)this._storageQueue.get(hsmName.toLowerCase() + "@" + storageClass);
    }

    public synchronized Enumeration getTriggeredClasses() {
        Vector<String> v = new Vector<String>();
        Iterator e = this._storageQueue.values().iterator();
        long now = new Date().getTime();
        while (e.hasNext()) {
            StorageClassInfo info = (StorageClassInfo)e.next();
            if (!info.isTriggered()) continue;
            v.addElement(info.getStorageClass());
        }
        return v.elements();
    }

    public synchronized boolean add(StorageInfo info, String pnfsId) {
        return this.add(info, pnfsId, -1L);
    }

    public synchronized boolean add(StorageInfo info, String pnfsId, long time) {
        String storageClass = info.getStorageClass();
        String hsmName = info.getHsm().toLowerCase();
        String composedName = storageClass + "@" + hsmName;
        StorageClassInfo classInfo = (StorageClassInfo)this._storageQueue.get(composedName);
        if (classInfo == null) {
            classInfo = new StorageClassInfo(hsmName, storageClass);
            this._storageQueue.put(composedName, classInfo);
        }
        classInfo.addRequest(new StorageRequestInfo(pnfsId, info, time));
        return classInfo.size() >= classInfo.getPending();
    }

    public synchronized void remove(String pnfsId) {
        for (StorageClassInfo classInfo : this._storageQueue.values()) {
            classInfo.removeRequest(pnfsId);
            if (classInfo.size() != 0 || classInfo.isDefined()) continue;
            this._storageQueue.remove(classInfo.getName() + "@" + classInfo.getHsm());
        }
    }

    public synchronized void remove(StorageInfo info, String pnfsId) {
        String storageClass = info.getStorageClass();
        String hsmName = info.getHsm().toLowerCase();
        String composedName = storageClass + "@" + hsmName;
        StorageClassInfo classInfo = (StorageClassInfo)this._storageQueue.get(composedName);
        if (classInfo == null) {
            return;
        }
        classInfo.removeRequest(pnfsId);
        if (classInfo.size() == 0 && !classInfo.isDefined()) {
            this._storageQueue.remove(composedName);
        }
    }

    private synchronized void reschedule(String storageClass, long time) {
        StorageClassInfo info = (StorageClassInfo)this._storageQueue.get(storageClass);
        if (info == null) {
            return;
        }
        info.setTime(time);
    }

    static /* synthetic */ long access$000(StorageQueue x0) {
        return x0._defaultExpiration;
    }

    static /* synthetic */ int access$100(StorageQueue x0) {
        return x0._defaultPending;
    }

    static /* synthetic */ int access$200(StorageQueue x0) {
        return x0._defaultPreference;
    }

    public class StorageClassInfo {
        private long _time = 0L;
        private Hashtable _requests = new Hashtable();
        private String _name = null;
        private long _expiration = StorageQueue.access$000(StorageQueue.this);
        private int _pending = StorageQueue.access$100(StorageQueue.this);
        private boolean _defined = false;
        private int _writePreference = StorageQueue.access$200(StorageQueue.this);
        private int _readPreference = StorageQueue.access$200(StorageQueue.this);
        private String _hsmName = "cache";

        private StorageClassInfo(String hsmName, String storageClass) {
            this._name = storageClass;
            this._hsmName = hsmName.toLowerCase();
        }

        public String getHsm() {
            return this._hsmName;
        }

        public String getName() {
            return this._name;
        }

        public Enumeration requests() {
            return this._requests.elements();
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("SCI=").append(this._name).append("@").append(this._hsmName).append(";def=").append(this._defined).append(";exp=").append(this._expiration / 1000L).append(";pend=").append(this._pending).append(";readpref=").append(this._readPreference).append(";writepref=").append(this._writePreference).append(";waiting=").append(this._requests.size());
            return sb.toString();
        }

        public boolean hasExpired() {
            return this._time + this._expiration > new Date().getTime();
        }

        public long expiresIn() {
            return (new Date().getTime() - (this._time + this._expiration)) / 1000L;
        }

        public boolean isFull() {
            return this._requests.size() >= this._pending;
        }

        public boolean isTriggered() {
            return this.hasExpired() || this.isFull();
        }

        public String getStorageClass() {
            return this._name;
        }

        private void setTime(long time) {
            this._time = time;
        }

        public long getTime() {
            return this._time;
        }

        private void setDefined(boolean d) {
            this._defined = d;
        }

        public boolean isDefined() {
            return this._defined;
        }

        public Enumeration getRequests() {
            return this._requests.elements();
        }

        private void addRequest(StorageRequestInfo request) {
            this._requests.put(request.getPnfsId(), request);
            if (this._time == 0L || request.getTime() < this._time) {
                this._time = request.getTime();
            }
        }

        public Iterator classes() {
            return StorageQueue.this._storageQueue.keySet().iterator();
        }

        public int size() {
            return this._requests.size();
        }

        private void removeRequest(String pnfsId) {
            this._requests.remove(pnfsId);
        }

        public void setExpiration(int expiration) {
            this._expiration = expiration * 1000;
        }

        public void setPending(int pending) {
            this._pending = pending;
        }

        public void setWritePreference(int preference) {
            this._writePreference = preference;
        }

        public void setReadPreference(int preference) {
            this._readPreference = preference;
        }

        public int getWritePreference() {
            return this._writePreference;
        }

        public int getReadPreference() {
            return this._readPreference;
        }

        public int getPending() {
            return this._pending;
        }

        public int getExpiration() {
            return (int)(this._expiration / 1000L);
        }
    }

    public class StorageRequestInfo {
        private String _pnfsId;
        private StorageInfo _info;
        private long _time = 0L;

        private StorageRequestInfo(String pnfsId, StorageInfo info) {
            this(pnfsId, info, -1L);
        }

        private StorageRequestInfo(String pnfsId, StorageInfo info, long time) {
            this._pnfsId = pnfsId;
            this._info = info;
            this._time = time < 0L ? new Date().getTime() : time;
        }

        public long getTime() {
            return this._time;
        }

        public String getPnfsId() {
            return this._pnfsId;
        }

        public StorageInfo getStorageInfo() {
            return this._info;
        }

        public String toString() {
            return "pnfsid=" + this._pnfsId + ";info=" + this._info;
        }
    }
}

