/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.util;

import diskCacheV111.util.PnfsIdUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PnfsId
implements Serializable,
Comparable<PnfsId> {
    private static final String SIMPLE_PNFS_ID_REGEX = "\\p{XDigit}{1,24}";
    private static final String STAR_PNFS_ID_REGEX = "\\p{XDigit}{1,22}\\*\\p{XDigit}{1,22}";
    private static final String PNFS_ID_REGEX = "(\\p{XDigit}{1,24}|\\p{XDigit}{1,22}\\*\\p{XDigit}{1,22})";
    private static final String PNFS_STRING_REGEX = "((\\p{XDigit}{1,24}|\\p{XDigit}{1,22}\\*\\p{XDigit}{1,22})(\\..*)?)";
    private static final String CHIMERA_ID_REGEX = "\\p{XDigit}{36}";
    private static final String VALID_ID_REGEX = "^(((\\p{XDigit}{1,24}|\\p{XDigit}{1,22}\\*\\p{XDigit}{1,22})(\\..*)?)|\\p{XDigit}{36})$";
    private static final Pattern VALID_ID_PATTERN = Pattern.compile("^(((\\p{XDigit}{1,24}|\\p{XDigit}{1,22}\\*\\p{XDigit}{1,22})(\\..*)?)|\\p{XDigit}{36})$");
    private static final int OLD_ID_SIZE = 12;
    private static final int NEW_ID_SIZE = 18;
    private final byte[] _a;
    private final String _domain;
    private static final long serialVersionUID = -112220393521303857L;
    private static final char[] valueToHex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static boolean isValid(String id) {
        Matcher m = VALID_ID_PATTERN.matcher(id);
        return m.matches();
    }

    public PnfsId(String id, String domain) {
        this(PnfsId._stringToBytes(id), domain);
    }

    public PnfsId(String s) {
        this(PnfsId.stringToId(s), PnfsId.stringToDomain(s));
    }

    public PnfsId(byte[] id) {
        this(id, null);
    }

    public PnfsId(byte[] id, String domain) {
        int length = id.length;
        if (length != 12 && length != 18) {
            throw new IllegalArgumentException("Illegal pnfsid string length");
        }
        this._a = new byte[length];
        System.arraycopy(id, 0, this._a, 0, length);
        this._domain = domain != null ? domain.intern() : null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PnfsId)) {
            return false;
        }
        PnfsId other = (PnfsId)o;
        return Arrays.equals(this._a, other._a) && (this._domain == other._domain || this._domain != null && this._domain.equals(other._domain));
    }

    public int hashCode() {
        return Arrays.hashCode(this._a) ^ (this._domain == null ? 0 : this._domain.hashCode());
    }

    @Override
    public int compareTo(PnfsId pnfsId) {
        if (pnfsId == this) {
            return 0;
        }
        int i = 0;
        for (i = 0; i < this._a.length && this._a[i] == pnfsId._a[i]; ++i) {
        }
        if (i == this._a.length) {
            return 0;
        }
        int t = this._a[i] < 0 ? 256 + this._a[i] : this._a[i];
        int o = pnfsId._a[i] < 0 ? 256 + pnfsId._a[i] : pnfsId._a[i];
        return t < o ? -1 : 1;
    }

    public int getDatabaseId() {
        return (this._a[0] & 0xFF) << 8 | this._a[1] & 0xFF;
    }

    public String getDomain() {
        return this._domain;
    }

    public String getId() {
        return PnfsId.bytesToHexString(this._a);
    }

    public String toString() {
        return this.getId() + (this._domain != null ? "." + this._domain : "");
    }

    public String toIdString() {
        return this.getId();
    }

    public static String toCompleteId(String shortId) {
        return PnfsId.bytesToHexString(PnfsId._stringToBytes(shortId));
    }

    public byte[] getBytes() {
        byte[] x = new byte[this._a.length];
        System.arraycopy(this._a, 0, x, 0, this._a.length);
        return x;
    }

    public String toShortString() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (i = 0; i < 2; ++i) {
            sb.append(PnfsId.byteToHexString(this._a[i]));
        }
        while (i < this._a.length && this._a[i] == 0) {
            ++i;
        }
        while (i < this._a.length) {
            sb.append(PnfsId.byteToHexString(this._a[i]));
            ++i;
        }
        return sb.toString();
    }

    private static final byte[] stringToId(String s) {
        int i = s.indexOf(46);
        if (i < 0) {
            return PnfsId._stringToBytes(s);
        }
        return PnfsId._stringToBytes(s.substring(0, i));
    }

    private static final String stringToDomain(String s) {
        int i = s.indexOf(46);
        if (i < 0 || i == s.length() - 1) {
            return null;
        }
        return s.substring(i + 1);
    }

    private static String byteToHexString(byte b) {
        String s = Integer.toHexString(b < 0 ? 256 + b : b).toUpperCase();
        if (s.length() == 1) {
            return "0" + s;
        }
        return s;
    }

    private static String bytesToHexString(byte[] b) {
        char[] result = new char[2 * b.length];
        for (int i = 0; i < b.length; ++i) {
            int value = b[i] + 256 & 0xFF;
            result[2 * i] = valueToHex[value >> 4];
            result[2 * i + 1] = valueToHex[value & 0xF];
        }
        return new String(result);
    }

    private static byte[] _stringToBytes(String idString) {
        int i;
        int len = idString.length();
        int idSize = 0;
        switch (len) {
            case 24: {
                idSize = 12;
                break;
            }
            case 36: {
                idSize = 18;
                break;
            }
            default: {
                if (len > 24 || len == 0) {
                    throw new IllegalArgumentException("Illegal pnfsid string length");
                }
                idSize = 12;
            }
        }
        byte[] a = new byte[idSize];
        int p = idString.indexOf(42);
        if (p > -1) {
            if (p == 0 || p == idString.length() - 1) {
                throw new IllegalArgumentException("Illegal use of *");
            }
            int diff = 24 - idString.length() + 1;
            StringBuilder sb = new StringBuilder();
            sb.append(idString.substring(0, p));
            for (i = 0; i < diff; ++i) {
                sb.append("0");
            }
            sb.append(idString.substring(p + 1));
            idString = sb.toString();
        }
        if (idString.length() > 2 * a.length) {
            throw new IllegalArgumentException("Illegal pnfsid string length");
        }
        if (idString.length() < 2 * a.length) {
            StringBuilder sb = new StringBuilder();
            int m = 24 - idString.length();
            for (i = 0; i < m; ++i) {
                sb.append("0");
            }
            sb.append(idString);
            idString = sb.toString();
        }
        for (int i2 = 0; i2 < idSize; ++i2) {
            int l = Integer.parseInt(idString.substring(2 * i2, 2 * (i2 + 1)), 16);
            a[i2] = (byte)(l < 128 ? l : l - 256);
        }
        return a;
    }

    public byte[] toBinPnfsId() {
        switch (this._a.length) {
            case 12: {
                return PnfsIdUtil.toBinPnfsId(this.getId());
            }
            case 18: {
                return this.getBytes();
            }
        }
        return null;
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("USAGE : ... <pnfsId>");
            System.exit(4);
        }
        try {
            PnfsId id = new PnfsId(args[0]);
            System.out.println("id.toString()      " + id);
            System.out.println("id.getId()         " + id.getId());
            System.out.println("db.getDatabaseId() " + id.getDatabaseId());
            System.out.println("db.getDomain()     " + id.getDomain());
            System.out.println("id.getBytes()      " + Arrays.toString(id.getBytes()));
            System.out.println("id.toBinPnfsId()   " + Arrays.toString(id.toBinPnfsId()));
            System.out.println("toStringPnfsId(id.toBinPnfsId()) " + PnfsIdUtil.toStringPnfsId(id.toBinPnfsId()));
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(4);
        }
    }
}

