/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.util;

import diskCacheV111.util.CacheException;
import diskCacheV111.util.FileMetaData;
import diskCacheV111.util.FileNotFoundCacheException;
import diskCacheV111.util.FsPath;
import diskCacheV111.util.PnfsId;
import diskCacheV111.vehicles.PnfsAddCacheLocationMessage;
import diskCacheV111.vehicles.PnfsClearCacheLocationMessage;
import diskCacheV111.vehicles.PnfsCreateDirectoryMessage;
import diskCacheV111.vehicles.PnfsCreateEntryMessage;
import diskCacheV111.vehicles.PnfsDeleteEntryMessage;
import diskCacheV111.vehicles.PnfsFlagMessage;
import diskCacheV111.vehicles.PnfsGetCacheLocationsMessage;
import diskCacheV111.vehicles.PnfsGetParentMessage;
import diskCacheV111.vehicles.PnfsGetStorageInfoMessage;
import diskCacheV111.vehicles.PnfsMapPathMessage;
import diskCacheV111.vehicles.PnfsMessage;
import diskCacheV111.vehicles.PnfsRenameMessage;
import diskCacheV111.vehicles.PnfsSetChecksumMessage;
import diskCacheV111.vehicles.PnfsSetFileMetaDataMessage;
import diskCacheV111.vehicles.PnfsSetLengthMessage;
import diskCacheV111.vehicles.PnfsSetStorageInfoMessage;
import diskCacheV111.vehicles.PoolFileFlushedMessage;
import diskCacheV111.vehicles.StorageInfo;
import dmg.cells.nucleus.CellEndpoint;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.NoRouteToCellException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.security.auth.Subject;
import org.dcache.acl.enums.AccessMask;
import org.dcache.cells.CellMessageSender;
import org.dcache.cells.CellStub;
import org.dcache.namespace.FileAttribute;
import org.dcache.namespace.FileType;
import org.dcache.util.Checksum;
import org.dcache.vehicles.FileAttributes;
import org.dcache.vehicles.PnfsGetFileAttributes;
import org.dcache.vehicles.PnfsSetFileAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PnfsHandler
implements CellMessageSender {
    private final String _poolName;
    private static final long DEFAULT_PNFS_TIMEOUT = 1800000L;
    private final CellStub _cellStub;
    private Subject _subject;
    private static final Logger _logNameSpace = LoggerFactory.getLogger((String)("logger.org.dcache.namespace." + PnfsHandler.class.getName()));

    private static CellStub createStub(CellPath path) {
        CellStub stub = new CellStub();
        stub.setDestinationPath(path);
        stub.setTimeout(1800000L);
        stub.setRetryOnNoRouteToCell(true);
        return stub;
    }

    @Deprecated
    public PnfsHandler(CellEndpoint endpoint, CellPath pnfsManagerPath, String poolName) {
        this(pnfsManagerPath, poolName);
        this.setCellEndpoint(endpoint);
    }

    @Deprecated
    public PnfsHandler(CellEndpoint endpoint, CellPath pnfsManagerPath) {
        this(pnfsManagerPath);
        this.setCellEndpoint(endpoint);
    }

    public PnfsHandler(CellPath pnfsManagerPath) {
        this(PnfsHandler.createStub(pnfsManagerPath));
    }

    public PnfsHandler(CellPath pnfsManagerPath, String poolName) {
        this(PnfsHandler.createStub(pnfsManagerPath), poolName);
    }

    public PnfsHandler(CellStub stub) {
        this(stub, "<client>");
    }

    public PnfsHandler(CellStub stub, String poolName) {
        this._cellStub = stub;
        this._poolName = poolName;
    }

    public PnfsHandler(PnfsHandler handler, Subject subject) {
        this._poolName = handler._poolName;
        this._cellStub = handler._cellStub;
        this._subject = subject;
    }

    @Override
    public void setCellEndpoint(CellEndpoint endpoint) {
        this._cellStub.setCellEndpoint(endpoint);
    }

    public void setSubject(Subject subject) {
        this._subject = subject;
    }

    public void send(PnfsMessage msg) throws NoRouteToCellException {
        if (this._cellStub == null) {
            throw new IllegalStateException("Missing endpoint");
        }
        if (this._subject != null) {
            msg.setSubject(this._subject);
        }
        this._cellStub.send(msg);
    }

    public void notify(PnfsMessage msg) {
        try {
            msg.setReplyRequired(false);
            this.send(msg);
        }
        catch (NoRouteToCellException e) {
            _logNameSpace.warn("Failed to deliver message " + msg.getClass().getSimpleName() + " to PnfsManager: " + e.getMessage());
        }
    }

    public void clearCacheLocation(PnfsId pnfsId) {
        this.clearCacheLocation(pnfsId, false);
    }

    public void clearCacheLocation(PnfsId pnfsId, boolean removeIfLast) {
        this.notify(new PnfsClearCacheLocationMessage(pnfsId, this._poolName, removeIfLast));
    }

    public void clearCacheLocation(PnfsId pnfsId, String poolName) {
        this.notify(new PnfsClearCacheLocationMessage(pnfsId, poolName));
    }

    public void addCacheLocation(PnfsId pnfsId) throws CacheException {
        this.pnfsRequest(new PnfsAddCacheLocationMessage(pnfsId, this._poolName));
    }

    public void setFileSize(PnfsId pnfsId, long length) throws CacheException {
        this.pnfsRequest(new PnfsSetLengthMessage(pnfsId, length));
    }

    public List<String> getCacheLocations(PnfsId pnfsId) throws CacheException {
        PnfsGetCacheLocationsMessage pnfsMessage = new PnfsGetCacheLocationsMessage(pnfsId);
        List<String> assumedLocations = (pnfsMessage = this.pnfsRequest(pnfsMessage)).getCacheLocations();
        if (assumedLocations == null) {
            return Collections.emptyList();
        }
        return assumedLocations;
    }

    public List<String> getCacheLocationsByPath(String fileName) throws CacheException {
        PnfsGetCacheLocationsMessage pnfsMessage = new PnfsGetCacheLocationsMessage();
        pnfsMessage.setPnfsPath(fileName);
        pnfsMessage = this.pnfsRequest(pnfsMessage);
        List<String> assumedLocations = pnfsMessage.getCacheLocations();
        if (assumedLocations == null) {
            return Collections.emptyList();
        }
        return assumedLocations;
    }

    public <T extends PnfsMessage> T pnfsRequest(T msg) throws CacheException {
        if (this._cellStub == null) {
            throw new IllegalStateException("Missing endpoint");
        }
        try {
            msg.setReplyRequired(true);
            if (this._subject != null) {
                msg.setSubject(this._subject);
            }
            return this._cellStub.sendAndWait(msg);
        }
        catch (InterruptedException e) {
            throw new CacheException(10011, "Sending message to PnafsManager intterupted");
        }
    }

    public PnfsCreateEntryMessage createPnfsDirectory(String path) throws CacheException {
        return this.pnfsRequest(new PnfsCreateDirectoryMessage(path));
    }

    public PnfsCreateEntryMessage createPnfsDirectory(String path, int uid, int gid, int mode) throws CacheException {
        return this.pnfsRequest(new PnfsCreateDirectoryMessage(path, uid, gid, mode));
    }

    public FileAttributes createDirectories(FsPath path) throws CacheException {
        PnfsCreateEntryMessage message;
        try {
            message = this.createPnfsDirectory(path.toString());
        }
        catch (FileNotFoundCacheException e) {
            this.createDirectories(path.getParent());
            message = this.createPnfsDirectory(path.toString());
        }
        if (message.getStorageInfo() == null) {
            try {
                this.deletePnfsEntry(message.getPnfsId(), path.toString());
            }
            catch (FileNotFoundCacheException e) {
            }
            catch (CacheException e) {
                _logNameSpace.error(e.toString());
            }
            throw new CacheException("Failed to create directory: " + path);
        }
        return message.getFileAttributes();
    }

    public PnfsCreateEntryMessage createPnfsEntry(String path) throws CacheException {
        return this.pnfsRequest(new PnfsCreateEntryMessage(path));
    }

    public void pnfsSetFileMetaData(PnfsId pnfsId, FileMetaData meta) throws CacheException {
        this.pnfsRequest(new PnfsSetFileMetaDataMessage(pnfsId, meta));
    }

    public void renameEntry(PnfsId pnfsId, String newName) throws CacheException {
        this.renameEntry(pnfsId, newName, true);
    }

    public void renameEntry(PnfsId pnfsId, String newName, boolean overwrite) throws CacheException {
        this.pnfsRequest(new PnfsRenameMessage(pnfsId, newName, overwrite));
    }

    public void renameEntry(String path, String newName, boolean overwrite) throws CacheException {
        this.pnfsRequest(new PnfsRenameMessage(path, newName, overwrite));
    }

    public PnfsCreateEntryMessage createPnfsEntry(String path, int uid, int gid, int mode) throws CacheException {
        return this.pnfsRequest(new PnfsCreateEntryMessage(path, uid, gid, mode));
    }

    public void setStorageInfoByPnfsId(PnfsId pnfsId, StorageInfo storageInfo, int accessMode) throws CacheException {
        this.pnfsRequest(new PnfsSetStorageInfoMessage(pnfsId, storageInfo, accessMode));
    }

    public PnfsGetStorageInfoMessage getStorageInfoByPnfsId(PnfsId pnfsId) throws CacheException {
        return this.pnfsRequest(new PnfsGetStorageInfoMessage(pnfsId));
    }

    public PnfsGetStorageInfoMessage getStorageInfoByPath(String pnfsPath) throws CacheException {
        return this.getStorageInfoByPath(pnfsPath, false);
    }

    public PnfsGetStorageInfoMessage getStorageInfoByPath(String pnfsPath, boolean requestChecksum) throws CacheException {
        PnfsGetStorageInfoMessage sInfo = new PnfsGetStorageInfoMessage();
        sInfo.setPnfsPath(pnfsPath);
        sInfo.setChecksumsRequested(requestChecksum);
        return this.pnfsRequest(sInfo);
    }

    public PnfsId getParentOf(PnfsId pnfsId) throws CacheException {
        return this.pnfsRequest(new PnfsGetParentMessage(pnfsId)).getParent();
    }

    public void deletePnfsEntry(String path) throws CacheException {
        this.deletePnfsEntry(null, path);
    }

    public void deletePnfsEntry(String path, Set<FileType> allowed) throws CacheException {
        this.deletePnfsEntry(null, path, allowed);
    }

    public void deletePnfsEntry(PnfsId pnfsid) throws CacheException {
        this.deletePnfsEntry(pnfsid, null);
    }

    public void deletePnfsEntry(PnfsId pnfsid, String path) throws CacheException {
        this.deletePnfsEntry(pnfsid, path, EnumSet.allOf(FileType.class));
    }

    public void deletePnfsEntry(PnfsId pnfsid, String path, Set<FileType> allowed) throws CacheException {
        this.pnfsRequest(new PnfsDeleteEntryMessage(pnfsid, path, allowed));
    }

    public long getPnfsTimeout() {
        return this._cellStub.getTimeout();
    }

    public void setPnfsTimeout(long pnfsTimeout) {
        this._cellStub.setTimeout(pnfsTimeout);
    }

    public String getPnfsFlag(PnfsId pnfsId, String flag) throws CacheException {
        PnfsFlagMessage flagMessage = new PnfsFlagMessage(pnfsId, flag, PnfsFlagMessage.FlagOperation.GET);
        flagMessage.setReplyRequired(true);
        return this.pnfsRequest(flagMessage).getValue();
    }

    public void putPnfsFlag(PnfsId pnfsId, String flag, String value) {
        PnfsFlagMessage flagMessage = new PnfsFlagMessage(pnfsId, flag, PnfsFlagMessage.FlagOperation.SET);
        flagMessage.setReplyRequired(false);
        flagMessage.setValue(value);
        this.notify(flagMessage);
    }

    public void fileFlushed(PnfsId pnfsId, StorageInfo storageInfo) throws CacheException {
        PoolFileFlushedMessage fileFlushedMessage = new PoolFileFlushedMessage(this._poolName, pnfsId, storageInfo);
        this.pnfsRequest(fileFlushedMessage);
    }

    public String getPathByPnfsId(PnfsId pnfsID) throws CacheException {
        return this.pnfsRequest(new PnfsMapPathMessage(pnfsID)).getGlobalPath();
    }

    public PnfsId getPnfsIdByPath(String path) throws CacheException {
        return this.pnfsRequest(new PnfsMapPathMessage(path)).getPnfsId();
    }

    public FileAttributes getFileAttributes(PnfsId pnfsid, Set<FileAttribute> attr) throws CacheException {
        return this.pnfsRequest(new PnfsGetFileAttributes(pnfsid, attr)).getFileAttributes();
    }

    public FileAttributes getFileAttributes(PnfsId pnfsid, Set<FileAttribute> attr, Set<AccessMask> mask) throws CacheException {
        PnfsGetFileAttributes msg = new PnfsGetFileAttributes(pnfsid, attr);
        msg.setAccessMask(mask);
        return this.pnfsRequest(msg).getFileAttributes();
    }

    public FileAttributes getFileAttributes(String path, Set<FileAttribute> attr) throws CacheException {
        return this.pnfsRequest(new PnfsGetFileAttributes(path, attr)).getFileAttributes();
    }

    public FileAttributes getFileAttributes(String path, Set<FileAttribute> attr, Set<AccessMask> mask) throws CacheException {
        PnfsGetFileAttributes msg = new PnfsGetFileAttributes(path, attr);
        msg.setAccessMask(mask);
        return this.pnfsRequest(msg).getFileAttributes();
    }

    public void setFileAttributes(PnfsId pnfsid, FileAttributes attr) throws CacheException {
        this.pnfsRequest(new PnfsSetFileAttributes(pnfsid, attr));
    }

    public void setChecksum(PnfsId pnfsId, Checksum checksum) throws CacheException {
        PnfsSetChecksumMessage message = new PnfsSetChecksumMessage(pnfsId, checksum.getType().getType(), checksum.getValue());
        this.pnfsRequest(message);
    }
}

