/*
 * Decompiled with CFR 0.152.
 */
package diskCacheV111.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class PathMap {
    private final HashMap _root = new HashMap();

    public void add(String path, Object node) {
        StringTokenizer st = new StringTokenizer(path, "/");
        HashMap current = this._root;
        HashMap newLevel = null;
        int count = st.countTokens();
        for (int i = 0; i < count; ++i) {
            String item = st.nextToken();
            Object o = current.get(item);
            if (o == null) {
                if (i == count - 1) {
                    current.put(item, node);
                    return;
                }
                newLevel = new HashMap();
                current.put(item, newLevel);
                current = newLevel;
                continue;
            }
            if (o instanceof Map) {
                if (i == count - 1) {
                    throw new IllegalArgumentException("Inconsistent path-2");
                }
                current = (Map)o;
                continue;
            }
            throw new IllegalArgumentException("Inconsistent path");
        }
    }

    public Entry match(String path) {
        StringTokenizer st = new StringTokenizer(path, "/");
        Map current = this._root;
        Object newLevel = null;
        while (st.hasMoreTokens()) {
            String item = st.nextToken();
            Object o = current.get(item);
            if (o == null) {
                throw new NoSuchElementException("Path doesn't match");
            }
            if (o instanceof Map) {
                current = (Map)o;
                continue;
            }
            StringBuffer sb = new StringBuffer();
            while (st.hasMoreTokens()) {
                sb.append("/").append(st.nextToken());
            }
            return new Entry(path, sb.toString(), o);
        }
        Map currentMap = this._root;
        while (true) {
            Iterator iter;
            if (!(iter = currentMap.values().iterator()).hasNext()) {
                throw new IllegalArgumentException("Path to short to match");
            }
            Object o = iter.next();
            if (!(o instanceof Map)) {
                return new Entry(path, "/", o);
            }
            currentMap = (Map)o;
        }
    }

    public static void main(String[] args) {
        PathMap map = new PathMap();
        if (args.length < 2) {
            System.err.println("Usage : ... <path> <path> ... <match>");
            System.exit(4);
        }
        for (int i = 0; i < args.length - 1; ++i) {
            map.add(args[i], args[i]);
        }
        Entry o = map.match(args[args.length - 1]);
        if (o == null) {
            System.out.println("Nothing assigned up to here");
        } else {
            System.out.println("-> " + ((Object)o).toString());
        }
        System.exit(0);
    }

    public static class Entry {
        private final String _key;
        private final String _rest;
        private final Object _node;

        private Entry(String key, String rest, Object node) {
            this._key = key;
            this._rest = rest;
            this._node = node;
        }

        public Object getNode() {
            return this._node;
        }

        public String getRest() {
            return this._rest;
        }

        public String getKey() {
            return this._key;
        }

        public String toString() {
            return "Key=" + this._key + ";rest=" + this._rest + ";node=" + this._node;
        }
    }
}

